/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.IProject;
import org.eclipse.sw360.antenna.api.configuration.ContextExtension;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.service.ServiceFactory;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.model.Configuration;

public class AntennaContext {
    private boolean debug;
    private Configuration configuration;
    private final ToolConfiguration toolConfiguration;
    private final IProject project;
    private IProcessingReporter processingReporter;
    private final ContextExtension contextExtension;
    private final ServiceFactory serviceFactory;

    private AntennaContext(ContextBuilder builder) {
        this.configuration = builder.configuration;
        this.toolConfiguration = builder.toolConfiguration;
        this.project = builder.project;
        this.contextExtension = builder.contextExtension;
        this.processingReporter = builder.processingReporter;
        this.serviceFactory = builder.serviceFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ToolConfiguration getToolConfiguration() {
        return this.toolConfiguration;
    }

    public IProject getProject() {
        return this.project;
    }

    public IProcessingReporter getProcessingReporter() {
        return this.processingReporter;
    }

    public <T> Optional<T> getGeneric(Class<? extends T> clazz) {
        return this.contextExtension.get(clazz);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public HttpClient getHttpClient() {
        return this.serviceFactory.createHttpClient(this.toolConfiguration.useProxy(), this.toolConfiguration.getProxyHost(), this.toolConfiguration.getProxyPort());
    }

    public ObjectMapper getObjectMapper() {
        return ServiceFactory.getObjectMapper();
    }

    public static class ContextBuilder {
        private final ServiceFactory serviceFactory;
        private Configuration configuration;
        private ToolConfiguration toolConfiguration;
        private IProject project;
        private ContextExtension contextExtension = new ContextExtension();
        private IProcessingReporter processingReporter;

        public ContextBuilder() {
            this(new ServiceFactory());
        }

        ContextBuilder(ServiceFactory serviceFactory) {
            this.serviceFactory = serviceFactory;
        }

        public ContextBuilder setToolConfiguration(ToolConfiguration configuration) {
            this.toolConfiguration = configuration;
            return this;
        }

        public ContextBuilder setProject(IProject project) {
            this.project = project;
            return this;
        }

        public ContextBuilder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ContextBuilder setProcessingReporter(IProcessingReporter processingReporter) {
            this.processingReporter = processingReporter;
            return this;
        }

        public AntennaContext buildContext() {
            return new AntennaContext(this);
        }

        public ContextBuilder setContextExtensions(ContextExtension contextExtension) {
            this.contextExtension = contextExtension;
            return this;
        }
    }
}

