/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIdentifier;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;

public final class ArtifactCoordinates
implements ArtifactIdentifier<ArtifactCoordinates>,
ArtifactFact<ArtifactCoordinates> {
    private final Map<String, Coordinate> coordinates = new HashMap<String, Coordinate>();
    private String typeOfMainCoordinate;

    private void putCoordinate(Coordinate coordinate) {
        if (coordinate != null) {
            String type = coordinate.getType();
            this.coordinates.put(type, coordinate);
            this.setTypeOfMainCoordinate(type);
        }
    }

    private void setTypeOfMainCoordinate(String type) {
        if (this.typeOfMainCoordinate == null || "generic".equals(this.typeOfMainCoordinate)) {
            this.typeOfMainCoordinate = type;
        }
    }

    private void putCoordinates(Collection<Coordinate> coordinates) {
        coordinates.forEach(this::putCoordinate);
    }

    public ArtifactCoordinates(Coordinate ... coordinatesToAdd) {
        this.putCoordinates(Arrays.asList(coordinatesToAdd));
    }

    public ArtifactCoordinates(Collection<Coordinate> coordinatesToAdd) {
        this.putCoordinates(coordinatesToAdd);
    }

    public ArtifactCoordinates(String typeOfMainCoordinate, Collection<Coordinate> coordinatesToAdd) {
        this.setTypeOfMainCoordinate(typeOfMainCoordinate);
        this.putCoordinates(coordinatesToAdd);
        if (!this.coordinates.containsKey(typeOfMainCoordinate)) {
            throw new ExecutionException("The type=[" + typeOfMainCoordinate + "] is missing in=" + this.toString());
        }
    }

    public ArtifactCoordinates(Set<String> coordinateStringsToAdd) {
        for (String coordinateStringToAdd : coordinateStringsToAdd) {
            this.putCoordinate(new Coordinate(coordinateStringToAdd));
        }
    }

    public boolean containsPurl(String coordinateString) {
        return this.containsPurl(new Coordinate(coordinateString));
    }

    public boolean containsPurl(Coordinate coordinate) {
        return this.coordinates.values().contains(coordinate);
    }

    public Set<Coordinate> getCoordinates() {
        return new HashSet<Coordinate>(this.coordinates.values());
    }

    public Optional<Coordinate> getCoordinateForType(String type) {
        return Optional.ofNullable(this.coordinates.get(type));
    }

    public Coordinate getMainCoordinate() {
        if (this.typeOfMainCoordinate == null) {
            throw new ExecutionException("Not yet any coordinate added");
        }
        return this.coordinates.get(this.typeOfMainCoordinate);
    }

    @Override
    public String prettyPrint() {
        return "Set ArtifactCoordinates to " + this.toString();
    }

    public String toString() {
        return this.coordinates.values().stream().map(PackageURLFacade::canonicalize).collect(Collectors.joining("\", \"", "[ \"", "\" ]"));
    }

    @Override
    public boolean matches(ArtifactIdentifier artifactIdentifier) {
        if (artifactIdentifier instanceof ArtifactCoordinates) {
            ArtifactCoordinates artifactCoordinates = (ArtifactCoordinates)artifactIdentifier;
            return this.coordinates.entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).anyMatch(e -> {
                Coordinate thisCoordinate = (Coordinate)e.getValue();
                Coordinate otherCoordinate = artifactCoordinates.coordinates.get(e.getKey());
                return thisCoordinate.matches(otherCoordinate);
            });
        }
        return false;
    }

    @Override
    public String getFactContentName() {
        return "ArtifactCoordinates";
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.size() == 0;
    }

    @Override
    public ArtifactCoordinates mergeWith(ArtifactCoordinates resultWithPrecedence) {
        return new ArtifactCoordinates(this.typeOfMainCoordinate, Stream.concat(this.coordinates.values().stream(), resultWithPrecedence.coordinates.values().stream()).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactCoordinates that = (ArtifactCoordinates)o;
        return Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates);
    }
}

