/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.coordinates;

import com.github.packageurl.PackageURL;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelectorHelper;
import org.eclipse.sw360.antenna.model.coordinates.CoordinateBuilder;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;

public final class Coordinate
extends PackageURLFacade {
    public Coordinate(PackageURL packageURL) {
        super(packageURL);
    }

    public Coordinate(String packageURLString) {
        super(packageURLString);
    }

    public Coordinate(String name, String version) {
        super("generic", null, name, version, null, null);
    }

    public Coordinate(String type, String namespace, String name, String version) {
        super(type, namespace, name, version, null, null);
    }

    public Coordinate(String type, String name, String version) {
        super(type, null, name, version, null, null);
    }

    public Coordinate(String type, String namespace, String name, String version, TreeMap<String, String> qualifiers, String subpath) {
        super(type, namespace, name, version, qualifiers, subpath);
    }

    public static CoordinateBuilder builder() {
        return new CoordinateBuilder();
    }

    public boolean matches(String packageUrlString) {
        return this.matches(new Coordinate(packageUrlString));
    }

    public boolean matches(Coordinate coordinate) {
        if (coordinate == null) {
            return false;
        }
        return ArtifactSelectorHelper.compareStringsAsWildcard(this.getScheme(), coordinate.getScheme()) && ArtifactSelectorHelper.compareStringsAsWildcard(this.getType(), coordinate.getType()) && ArtifactSelectorHelper.compareStringsAsWildcard(this.getNamespace(), coordinate.getNamespace()) && ArtifactSelectorHelper.compareStringsAsWildcard(this.getName(), coordinate.getName()) && ArtifactSelectorHelper.compareStringsAsWildcard(this.getVersion(), coordinate.getVersion()) && ArtifactSelectorHelper.compareStringsAsWildcard(this.getSubpath(), coordinate.getSubpath());
    }

    public static class Types
    extends PackageURL.StandardTypes {
        public static final String P2 = "p2";
        public static final Set<String> all = Collections.unmodifiableSet(Stream.of("bitbucket", "composer", "deb", "docker", "gem", "generic", "github", "golang", "maven", "npm", "nuget", "pypi", "rpm", "p2").collect(Collectors.toSet()));
    }
}

