/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.coordinates;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;

public abstract class PackageURLFacade {
    private final PackageURL packageURL;

    PackageURLFacade(PackageURL packageURL) {
        this.packageURL = packageURL;
    }

    PackageURLFacade(String packageURLString) {
        try {
            this.packageURL = new PackageURL(packageURLString);
        }
        catch (MalformedPackageURLException e) {
            throw new ExecutionException("Failed to create PackageURL in Coordinate for string " + packageURLString, e);
        }
    }

    PackageURLFacade(String type, String namespace, String name, String version, TreeMap<String, String> qualifiers, String subpath) {
        try {
            this.packageURL = new PackageURL(type, namespace, name, version, qualifiers, subpath);
        }
        catch (MalformedPackageURLException e) {
            throw new ExecutionException(String.format("Failed to create PackageURL in Coordinate for data: %s %s %s %s %s %s", type, namespace, name, version, qualifiers, subpath), e);
        }
    }

    public PackageURL getPackageURL() {
        return this.packageURL;
    }

    public String getScheme() {
        return this.packageURL.getScheme();
    }

    public final String getType() {
        return this.packageURL.getType();
    }

    public String getNamespace() {
        return this.packageURL.getNamespace();
    }

    public boolean hasNamespace() {
        return this.getNamespace() != null && !"".equals(this.getNamespace());
    }

    public String getName() {
        return this.packageURL.getName();
    }

    public String getVersion() {
        return this.packageURL.getVersion();
    }

    public Map<String, String> getQualifiers() {
        return this.packageURL.getQualifiers();
    }

    public String getSubpath() {
        return this.packageURL.getSubpath();
    }

    public String toString() {
        return this.packageURL.toString();
    }

    public String canonicalize() {
        return this.packageURL.canonicalize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageURLFacade coordinate = (PackageURLFacade)o;
        return Objects.equals(this.packageURL.canonicalize(), coordinate.packageURL.canonicalize());
    }

    public int hashCode() {
        return Objects.hash(this.packageURL.canonicalize());
    }
}

