/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseOperator;

public class LicenseStatement
implements LicenseInformation {
    private Collection<LicenseInformation> licenses = new ArrayList<LicenseInformation>();
    private LicenseOperator op;

    public LicenseStatement() {
        this(null, null);
    }

    public LicenseStatement(Collection<LicenseInformation> licenses, LicenseOperator op) {
        if (licenses != null) {
            this.licenses.addAll(licenses);
        }
        this.op = op != null ? op : LicenseOperator.AND;
    }

    public void setLicenses(Collection<LicenseInformation> licenses) {
        this.licenses.clear();
        if (licenses != null) {
            this.licenses.addAll(licenses);
        }
    }

    public LicenseOperator getOp() {
        return this.op;
    }

    public void setOp(LicenseOperator operator) {
        this.op = operator != null ? operator : LicenseOperator.AND;
    }

    public boolean addLicenseInformation(LicenseInformation license) {
        if (license != null) {
            return this.licenses.add(license);
        }
        return false;
    }

    @Override
    public String evaluate() {
        if (this.isEmpty()) {
            return "";
        }
        return this.licenses.stream().map(LicenseInformation::evaluate).collect(Collectors.joining(" " + this.op.toString() + " ", "( ", " )"));
    }

    @Override
    public boolean isEmpty() {
        return this.licenses.isEmpty() || this.licenses.stream().allMatch(LicenseInformation::isEmpty);
    }

    public Collection<LicenseInformation> getStatementOperands() {
        return Collections.unmodifiableCollection(this.licenses);
    }

    @Override
    public Collection<License> getLicenses() {
        return this.licenses.stream().map(LicenseInformation::getLicenses).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseStatement that = (LicenseStatement)o;
        return Objects.equals(this.licenses, that.licenses) && this.op == that.op;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.licenses, this.op});
    }

    public String toString() {
        return this.evaluate();
    }
}

