/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;

public class WithLicense
extends License
implements LicenseInformation {
    private static final String SEPARATOR = " WITH ";
    private static final String TEXT_SEPARATOR = "with exception:";
    private static final String ERROR_MESSAGE_TEMPLATE = "Parameter %s is not separated properly with '%s'";
    private String exceptionId;
    private String exceptionName;
    private String exceptionText;

    public WithLicense() {
        this(null, null);
    }

    public WithLicense(String licenseId, String exceptionId) {
        this(licenseId, null, null, exceptionId, null, null);
    }

    public WithLicense(String licenseId, String licenseName, String licenseText, String exceptionId, String exceptionName, String exceptionText) {
        super(licenseId, licenseName, licenseText);
        this.exceptionId = exceptionId != null ? exceptionId : "";
        this.exceptionName = exceptionName != null ? exceptionName : "";
        this.exceptionText = exceptionText != null ? exceptionText : "";
    }

    public WithLicense(String licenseId, String licenseName, String licenseText) {
        this.exceptionId = this.separateStringAndSetFirst(licenseId, SEPARATOR, x$0 -> super.setId((String)x$0));
        this.exceptionName = this.separateStringAndSetFirst(licenseName, SEPARATOR, x$0 -> super.setCommonName((String)x$0));
        this.exceptionText = this.separateStringAndSetFirst(licenseText, TEXT_SEPARATOR, x$0 -> super.setText((String)x$0));
    }

    private String separateStringAndSetFirst(String source, String separator, Consumer<String> consumer) {
        String[] splitted = source.split(separator);
        if (splitted.length != 2) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, source, separator));
        }
        consumer.accept(splitted[0].trim());
        return splitted[1].trim();
    }

    @Override
    public String getId() {
        return this.evaluate();
    }

    @Override
    public void setId(String id) {
        this.exceptionId = this.separateStringAndSetFirst(id, SEPARATOR, x$0 -> super.setId((String)x$0));
    }

    @Override
    public String getCommonName() {
        if ("".equals(super.getCommonName()) || "".equals(this.exceptionName)) {
            return "";
        }
        return super.getCommonName() + SEPARATOR + this.exceptionName;
    }

    @Override
    public void setCommonName(String commonName) {
        this.exceptionName = this.separateStringAndSetFirst(commonName, SEPARATOR, x$0 -> super.setCommonName((String)x$0));
    }

    @Override
    public String getText() {
        if ("".equals(super.getText()) || "".equals(this.exceptionText)) {
            return "";
        }
        return super.getText() + "\n\n" + TEXT_SEPARATOR + "\n\n" + this.exceptionText;
    }

    @Override
    public void setText(String text) {
        this.exceptionText = this.separateStringAndSetFirst(text, TEXT_SEPARATOR, x$0 -> super.setText((String)x$0));
    }

    public String getLicenseId() {
        return super.getId();
    }

    public void setLicenseId(String licenseId) {
        super.setId(licenseId);
    }

    public String getLicenseName() {
        return super.getCommonName();
    }

    public void setLicenseName(String licenseName) {
        super.setCommonName(licenseName);
    }

    public String getLicenseText() {
        return super.getText();
    }

    public void setLicenseText(String licenseText) {
        super.setText(licenseText);
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public void setExceptionId(String exceptionId) {
        this.exceptionId = exceptionId != null ? exceptionId : "";
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public void setExceptionName(String exceptionName) {
        this.exceptionName = exceptionName != null ? exceptionName : "";
    }

    public String getExceptionText() {
        return this.exceptionText;
    }

    public void setExceptionText(String exceptionText) {
        this.exceptionText = exceptionText != null ? exceptionText : "";
    }

    @Override
    public String evaluate() {
        if (this.isEmpty()) {
            return "";
        }
        return super.getId() + SEPARATOR + this.exceptionId;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.exceptionId.trim().isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        boolean parent = super.equals(o);
        if (parent && this.getClass().equals(o.getClass())) {
            WithLicense that = (WithLicense)o;
            return Objects.equals(this.exceptionId, that.exceptionId) && Objects.equals(this.exceptionName, that.exceptionName) && Objects.equals(this.exceptionText, that.exceptionText);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.exceptionId.hashCode(), this.exceptionName.hashCode(), this.exceptionText.hashCode());
    }
}

