/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.api;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCore;

public interface IEvaluationResult {
    public String getId();

    public String getDescription();

    public Severity getSeverity();

    public Set<Artifact> getFailedArtifacts();

    default public String resultAsMessage() {
        return String.format("%s (%s): %s%n          %s", new Object[]{this.getId(), this.getSeverity(), this.getFailedArtifacts().stream().map(ArtifactCore::artifactAsCoordinate).collect(Collectors.joining(", ")), this.getDescription()});
    }

    public static enum Severity {
        INFO,
        WARN,
        FAIL;


        public String value() {
            return this.name();
        }

        public static Severity fromValue(String v) {
            return Severity.valueOf(v);
        }
    }
}

