/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.artifact.IPrettyPrintable;

public class ArtifactFlags
implements IPrettyPrintable {
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();

    @Override
    public String prettyPrint() {
        return this.flags.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((Boolean)e.getValue()).toString()).collect(Collectors.joining(", ", "[", "]"));
    }

    public void setFlag(String key, boolean value) {
        this.flags.put(key, value);
    }

    public boolean getFlag(String key) {
        return Optional.ofNullable(this.flags.get(key)).orElse(false);
    }

    public Map<String, Boolean> getRawContent() {
        return new HashMap<String, Boolean>(this.flags);
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactFlags that = (ArtifactFlags)o;
        return Objects.equals(this.flags, that.flags);
    }

    public int hashCode() {
        return Objects.hash(this.flags);
    }
}

