/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.api.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.http.HttpClientFactory;
import org.eclipse.sw360.antenna.http.HttpClientFactoryImpl;
import org.eclipse.sw360.antenna.http.config.HttpClientConfig;
import org.eclipse.sw360.antenna.http.config.ProxySettings;

public class ServiceFactory {
    private final HttpClientFactory httpClientFactory;
    private final ConcurrentMap<ProxySettings, HttpClient> httpClients;

    public ServiceFactory() {
        this((HttpClientFactory)new HttpClientFactoryImpl());
    }

    ServiceFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
        this.httpClients = new ConcurrentHashMap<ProxySettings, HttpClient>();
    }

    public static ObjectMapper getObjectMapper() {
        return LazyMapperHolder.MAPPER;
    }

    public HttpClient createHttpClient(boolean useProxy, String proxyHost, int proxyPort) {
        ProxySettings proxySettings = ProxySettings.fromConfig((boolean)useProxy, (String)proxyHost, (int)proxyPort);
        return this.httpClients.computeIfAbsent(proxySettings, this::createHttpClient);
    }

    private HttpClient createHttpClient(ProxySettings settings) {
        HttpClientConfig clientConfig = ServiceFactory.createHttpClientConfig(settings);
        return this.httpClientFactory.newHttpClient(clientConfig);
    }

    private static HttpClientConfig createHttpClientConfig(ProxySettings settings) {
        return HttpClientConfig.basicConfig().withObjectMapper(ServiceFactory.getObjectMapper()).withProxySettings(settings);
    }

    private static class LazyMapperHolder {
        private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        private LazyMapperHolder() {
        }
    }
}

