/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.api.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.workflow.WorkflowStepResult;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingState {
    private List<Artifact> artifacts = new ArrayList<Artifact>();
    private final Map<String, IAttachable> attachableMap = new HashMap<String, IAttachable>();
    private final List<String> additionalReportComments = new ArrayList<String>();
    private final Map<String, Set<IEvaluationResult>> failCausingResults = new HashMap<String, Set<IEvaluationResult>>();
    private final Logger LOGGER = LoggerFactory.getLogger(ProcessingState.class);

    public ProcessingState(Collection<WorkflowStepResult> initialResults) {
        if (initialResults == null) {
            return;
        }
        this.checkingDuplicateArtifactsInWorkflowStepResults(initialResults);
        initialResults.forEach(wsr -> this.applyWorkflowStepResult((WorkflowStepResult)wsr, true));
    }

    public Set<Artifact> getArtifacts() {
        return new HashSet<Artifact>(this.artifacts);
    }

    public Map<String, IAttachable> getAttachables() {
        return this.attachableMap;
    }

    public List<String> getAdditionalReportComments() {
        return this.additionalReportComments;
    }

    public Map<String, Set<IEvaluationResult>> getFailCausingResults() {
        return this.failCausingResults;
    }

    public void applyWorkflowStepResult(WorkflowStepResult workflowStepResult) {
        this.applyWorkflowStepResult(workflowStepResult, false);
    }

    public void applyWorkflowStepResult(WorkflowStepResult workflowStepResult, boolean forceAppend) {
        if (forceAppend || workflowStepResult.isArtifactsShouldBeAppended()) {
            this.artifacts.addAll(workflowStepResult.getArtifacts());
        } else {
            this.artifacts = new ArrayList<Artifact>(workflowStepResult.getArtifacts());
        }
        this.attachableMap.putAll(workflowStepResult.getAttachables());
        this.additionalReportComments.addAll(workflowStepResult.getAdditionalReportComments());
        Optional.ofNullable(workflowStepResult.getFailCausingResults()).map(failCausingResult -> this.failCausingResults.put((String)failCausingResult.getKey(), (Set<IEvaluationResult>)failCausingResult.getValue()));
    }

    private void checkingDuplicateArtifactsInWorkflowStepResults(Collection<WorkflowStepResult> initialResults) {
        List potentialArtifactDuplicates = initialResults.stream().filter(WorkflowStepResult::isArtifactsShouldBeAppended).flatMap(ir -> initialResults.stream().filter(ir2 -> !ir2.equals(ir)).map(ir::getPotentialDuplicatesWith)).flatMap(Collection::stream).collect(Collectors.toList());
        if (!potentialArtifactDuplicates.isEmpty()) {
            this.LOGGER.warn("Potentially conflicting artifacts were generated by the analyzers, this could lead to potential duplicate artifacts in the report. \n" + potentialArtifactDuplicates.stream().map(a -> "Potentially conflicting artifact: " + a.prettyPrint() + "\n").collect(Collectors.toList()).toString());
        }
    }
}

