/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;
import org.eclipse.sw360.antenna.model.artifact.FromXmlArtifactBuilder;
import org.eclipse.sw360.antenna.model.license.FromXmlLicenseInformationBuilder;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.xml.generated.AntennaConfig;
import org.eclipse.sw360.antenna.model.xml.generated.AttributeOverride;
import org.eclipse.sw360.antenna.model.xml.generated.FromXmlArtifactSelectorBuilder;
import org.eclipse.sw360.antenna.model.xml.generated.IgnoreForSourceValidation;
import org.eclipse.sw360.antenna.model.xml.generated.Issues;
import org.eclipse.sw360.antenna.model.xml.generated.SecurityIssue;
import org.eclipse.sw360.antenna.model.xml.generated.SetFinalLicense;
import org.eclipse.sw360.antenna.model.xml.generated.SourceValidation;
import org.eclipse.sw360.antenna.model.xml.generated.Suppress;

public class Configuration {
    private List<ArtifactSelector> ignoreForSourceResolving = new ArrayList<ArtifactSelector>();
    private Map<ArtifactSelector, Artifact> override = new HashMap<ArtifactSelector, Artifact>();
    private List<ArtifactSelector> validForMissingSources = new ArrayList<ArtifactSelector>();
    private List<ArtifactSelector> validForIncompleteSources = new ArrayList<ArtifactSelector>();
    private List<ArtifactSelector> removeArtifact = new ArrayList<ArtifactSelector>();
    private List<ArtifactSelector> preferP2 = new ArrayList<ArtifactSelector>();
    private List<Artifact> addArtifact = new ArrayList<Artifact>();
    private Map<ArtifactSelector, Issues> securityIssues = new HashMap<ArtifactSelector, Issues>();
    private Map<String, Map<ArtifactSelector, GregorianCalendar>> suppressedSecurityIssues;
    private Map<ArtifactSelector, LicenseInformation> finalLicenses = new HashMap<ArtifactSelector, LicenseInformation>();
    private boolean failOnIncompleteSources = false;
    private boolean failOnMissingSources = false;
    public static final BinaryOperator<Map<ArtifactSelector, GregorianCalendar>> suppressedSecurityIssuesConflictResolver = (suppressMap1, suppressMap2) -> Stream.concat(suppressMap1.entrySet().stream(), suppressMap2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (date1, date2) -> date1.compareTo((Calendar)date2) < 0 ? date1 : date2));

    public Configuration() {
    }

    public Configuration(AntennaConfig antennaConfig) {
        if (antennaConfig != null) {
            this.setRemoveArtifact(this.createListOfArtifactSelector(antennaConfig.getRemoveArtifact().getArtifactSelector()));
            this.createHandleAsValid(antennaConfig.getSourceValidation());
            this.setOverride(this.createOverride(antennaConfig.getOverrides().getOverride()));
            this.setFinalLicenses(this.createFinalLicenses(antennaConfig.getSetFinalLicenses().getSetFinalLicense()));
            if (antennaConfig.getSourceResolving().getIgnoreForSourceResolving() != null) {
                this.setIgnoreForSourceResolving(this.createListOfArtifactSelector(antennaConfig.getSourceResolving().getIgnoreForSourceResolving().getArtifactSelector()));
            }
            this.setFailOnIncompleteSources(antennaConfig.getSourceValidation().isFailOnIncompleteSources());
            this.setFailOnMissingSources(antennaConfig.getSourceValidation().isFailOnMissingSources());
            if (antennaConfig.getSourceResolving().getPreferP2() != null) {
                this.setPrefereP2(this.createListOfArtifactSelector(antennaConfig.getSourceResolving().getPreferP2().getArtifactSelector()));
            }
            this.setAddArtifact(antennaConfig.getAddArtifact().getArtifact().stream().map(FromXmlArtifactBuilder::build).collect(Collectors.toList()));
            this.setSecurityIssuesByList(antennaConfig.getSecurityIssues().getSecurityIssue());
            this.setSecurityIssueSuppressesByList(antennaConfig.getSecurityIssues().getSuppress());
        }
    }

    private List<ArtifactSelector> createListOfArtifactSelector(List<FromXmlArtifactSelectorBuilder> generatedSelectors) {
        return generatedSelectors.stream().map(FromXmlArtifactSelectorBuilder::build).collect(Collectors.toList());
    }

    private void createHandleAsValid(SourceValidation sourceValidation) {
        List<IgnoreForSourceValidation> list = sourceValidation.getHandleSourceAsValid();
        for (IgnoreForSourceValidation ignore : list) {
            if (ignore.isIncompleteSources()) {
                this.validForIncompleteSources.add(ignore.getArtifactSelector().build());
            }
            if (!ignore.isMissingSources()) continue;
            this.validForMissingSources.add(ignore.getArtifactSelector().build());
        }
    }

    private Map<ArtifactSelector, LicenseInformation> createFinalLicenses(List<SetFinalLicense> setFinalLicenses) {
        HashMap<ArtifactSelector, LicenseInformation> finalLicenses = new HashMap<ArtifactSelector, LicenseInformation>();
        for (SetFinalLicense entry : setFinalLicenses) {
            finalLicenses.put(entry.getArtifactSelector().build(), ((FromXmlLicenseInformationBuilder.ILicenseInformationBuilder)entry.getLicenseInfo().getValue()).build());
        }
        return finalLicenses;
    }

    private Map<ArtifactSelector, Artifact> createOverride(List<AttributeOverride> overrideList) {
        HashMap<ArtifactSelector, Artifact> overrideMap = new HashMap<ArtifactSelector, Artifact>();
        for (AttributeOverride override : overrideList) {
            overrideMap.put(override.getArtifactSelector().build(), override.getOverrideValue().getArtifact().build());
        }
        return overrideMap;
    }

    public List<ArtifactSelector> getIgnoreForSourceResolving() {
        return this.ignoreForSourceResolving;
    }

    public void setIgnoreForSourceResolving(List<ArtifactSelector> ignoreForSourceResolving) {
        this.ignoreForSourceResolving = ignoreForSourceResolving;
        for (ArtifactSelector artifactSelector : ignoreForSourceResolving) {
            this.getValidForMissingSources().add(artifactSelector);
            this.getValidForIncompleteSources().add(artifactSelector);
        }
    }

    public Map<ArtifactSelector, Artifact> getOverride() {
        return this.override;
    }

    public void setOverride(Map<ArtifactSelector, Artifact> override) {
        this.override = override;
    }

    public List<ArtifactSelector> getRemoveArtifact() {
        return this.removeArtifact;
    }

    public void setRemoveArtifact(List<ArtifactSelector> list) {
        this.removeArtifact = list;
    }

    public List<ArtifactSelector> getValidForMissingSources() {
        return this.validForMissingSources;
    }

    public void setValidForMissingSources(List<ArtifactSelector> validForMissingSources) {
        this.validForMissingSources = validForMissingSources;
    }

    public List<ArtifactSelector> getValidForIncompleteSources() {
        return this.validForIncompleteSources;
    }

    public void setValidForIncompleteSources(List<ArtifactSelector> validForIncompleteSources) {
        this.validForIncompleteSources = validForIncompleteSources;
    }

    public Map<ArtifactSelector, LicenseInformation> getFinalLicenses() {
        return this.finalLicenses;
    }

    public void setFinalLicenses(Map<ArtifactSelector, LicenseInformation> finalLicenses) {
        this.finalLicenses = finalLicenses;
    }

    public boolean isFailOnIncompleteSources() {
        return this.failOnIncompleteSources;
    }

    public void setFailOnIncompleteSources(boolean failOnIncompleteSources) {
        this.failOnIncompleteSources = failOnIncompleteSources;
    }

    public boolean isFailOnMissingSources() {
        return this.failOnMissingSources;
    }

    public void setFailOnMissingSources(boolean failOnMissingSources) {
        this.failOnMissingSources = failOnMissingSources;
    }

    public List<ArtifactSelector> getPrefereP2() {
        return this.preferP2;
    }

    public void setPrefereP2(List<ArtifactSelector> prefereP2) {
        this.preferP2 = prefereP2;
    }

    public List<Artifact> getAddArtifact() {
        return this.addArtifact;
    }

    public void setAddArtifact(List<Artifact> addArtifact) {
        this.addArtifact = addArtifact;
    }

    public Map<ArtifactSelector, Issues> getSecurityIssues() {
        return this.securityIssues;
    }

    public void setSecurityIssues(Map<ArtifactSelector, Issues> securityIssues) {
        this.securityIssues = securityIssues;
    }

    private void setSecurityIssuesByList(List<SecurityIssue> securityIssues) {
        this.securityIssues = securityIssues.stream().collect(Collectors.toMap(securityIssue -> securityIssue.getArtifactSelector().build(), SecurityIssue::getIssues));
    }

    public Map<String, Map<ArtifactSelector, GregorianCalendar>> getSuppressedSecurityIssues() {
        return this.suppressedSecurityIssues;
    }

    public void setSuppressedSecurityIssues(Map<String, Map<ArtifactSelector, GregorianCalendar>> suppressedSecurityIssues) {
        this.suppressedSecurityIssues = suppressedSecurityIssues;
    }

    private void setSecurityIssueSuppressesByList(List<Suppress> suppresses) {
        Function<Suppress, String> keyMapper = Suppress::getReference;
        Function<Suppress, Map> valueMapper = suppress -> Collections.singletonMap(suppress.getArtifactSelector().build(), suppress.getUntil().toGregorianCalendar());
        this.suppressedSecurityIssues = suppresses.stream().collect(Collectors.toMap(keyMapper, valueMapper, suppressedSecurityIssuesConflictResolver));
    }
}

