/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCore;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFile;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIdentifier;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactMatchingMetadata;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceFile;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.xml.generated.MatchState;

public class Artifact
extends ArtifactCore {
    public static final String IS_PROPRIETARY_FLAG_KEY = "isProprietary";
    public static final String IS_MODIFIED_BY_CONFIGURATION_FLAG_KEY = "isModifiedByConfiguration";
    public static final String IS_IGNORE_FOR_DOWNLOAD_KEY = "isIgnoreForDownload";

    public Artifact() {
    }

    public Artifact(String analysisSource) {
        super(analysisSource);
    }

    @Override
    public Artifact addFact(ArtifactFact artifactFact) {
        return (Artifact)super.addFact(artifactFact);
    }

    @Override
    public Artifact addCoordinate(Coordinate coordinate) {
        return (Artifact)super.addCoordinate(coordinate);
    }

    @Override
    public Artifact setFlag(String key) {
        return (Artifact)super.setFlag(key);
    }

    @Override
    public Artifact setFlag(String key, boolean value) {
        return (Artifact)super.setFlag(key, value);
    }

    public boolean isProprietary() {
        return this.getFlag(IS_PROPRIETARY_FLAG_KEY);
    }

    public Artifact setProprietary(boolean isProprietary) {
        return this.setFlag(IS_PROPRIETARY_FLAG_KEY, isProprietary);
    }

    public Optional<Path> getFile() {
        return this.askForGet(ArtifactFile.class);
    }

    public Optional<Path> getSourceFile() {
        return this.askForGet(ArtifactSourceFile.class);
    }

    public void setMatchState(MatchState matchState) {
        this.addFact(new ArtifactMatchingMetadata(matchState));
    }

    public MatchState getMatchState() {
        return this.askFor(ArtifactMatchingMetadata.class).map(ArtifactMatchingMetadata::getMatchState).orElse(MatchState.UNKNOWN);
    }

    public boolean isPotentialDuplicateOf(Artifact compareA) {
        return this.getArtifactIdentifiers().stream().anyMatch(identifier -> compareA.getArtifactIdentifiers().stream().anyMatch(compareIdentifier -> compareIdentifier.matches((ArtifactIdentifier)identifier) || identifier.matches((ArtifactIdentifier)compareIdentifier)));
    }

    public void mergeWith(Artifact newArtifact) {
        if (this.isPotentialDuplicateOf(newArtifact)) {
            newArtifact.askForAll(ArtifactFact.class).forEach(this::addFact);
        }
    }
}

