/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFactWithPayload;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFlags;
import org.eclipse.sw360.antenna.model.artifact.IPrettyPrintable;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIdentifier;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCore
implements IPrettyPrintable {
    private final Map<Class<? extends ArtifactFact>, ArtifactFact> artifactFacts = new HashMap<Class<? extends ArtifactFact>, ArtifactFact>();
    private final ArtifactFlags artifactFlags = new ArtifactFlags();
    private final Optional<String> analysisSource;
    private final Logger LOGGER = LoggerFactory.getLogger(ArtifactCore.class);

    public ArtifactCore() {
        this.analysisSource = Optional.empty();
    }

    public ArtifactCore(String analysisSource) {
        this.analysisSource = Optional.ofNullable(analysisSource);
    }

    private <T extends ArtifactFact> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    private <T extends ArtifactFact> Stream<T> filterEmptyFacts(Stream<T> stream) {
        return stream.filter(this.not(ArtifactFact::isEmpty));
    }

    private <T extends ArtifactFact> Optional<T> filterEmptyFacts(Optional<T> stream) {
        return stream.filter(this.not(ArtifactFact::isEmpty));
    }

    public ArtifactCore addFact(ArtifactFact artifactFact) {
        this.LOGGER.trace(artifactFact.prettyPrint());
        Class<ArtifactFact> rowClass = artifactFact.getKey();
        if (this.artifactFacts.containsKey(rowClass)) {
            this.artifactFacts.put(rowClass, this.artifactFacts.get(rowClass).mergeWith(artifactFact));
        } else {
            this.artifactFacts.put(rowClass, artifactFact);
        }
        return this;
    }

    public ArtifactCore addCoordinate(Coordinate coordinate) {
        return this.addFact(new ArtifactCoordinates(coordinate));
    }

    public Set<Coordinate> getCoordinates() {
        return this.askFor(ArtifactCoordinates.class).map(ArtifactCoordinates::getCoordinates).orElse(Collections.emptySet());
    }

    public Optional<Coordinate> getCoordinateForType(String type) {
        return this.askFor(ArtifactCoordinates.class).flatMap(a -> a.getCoordinateForType(type));
    }

    public Optional<Coordinate> getMainCoordinate() {
        return this.askFor(ArtifactCoordinates.class).map(ArtifactCoordinates::getMainCoordinate);
    }

    public <T extends ArtifactFact> Optional<T> askFor(Class<T> rowClass) {
        return this.filterEmptyFacts(Optional.ofNullable(this.artifactFacts.get(rowClass)).filter(rowClass::isInstance).map(rowClass::cast));
    }

    public <T extends ArtifactFact> List<T> askForAll(Class<T> rowSuperClass) {
        return this.filterEmptyFacts(this.artifactFacts.entrySet().stream().filter(classArtifactFactEntry -> rowSuperClass.isAssignableFrom((Class)classArtifactFactEntry.getKey())).map(Map.Entry::getValue).map(o -> o)).collect(Collectors.toList());
    }

    public <S, T extends ArtifactFactWithPayload<S>> Optional<S> askForGet(Class<T> rowClass) {
        return this.askFor(rowClass).map(ArtifactFactWithPayload::get);
    }

    public List<ArtifactIdentifier> getArtifactIdentifiers() {
        return this.askForAll(ArtifactIdentifier.class);
    }

    public ArtifactCore setFlag(String key, boolean value) {
        this.artifactFlags.setFlag(key, value);
        return this;
    }

    public ArtifactCore setFlag(String key) {
        this.artifactFlags.setFlag(key, true);
        return this;
    }

    public boolean getFlag(String key) {
        return this.artifactFlags.getFlag(key);
    }

    public String getAnalysisSource() {
        return this.analysisSource.orElse("UNKNOWN");
    }

    public void overrideWith(ArtifactCore artifactWithPrecedence) {
        this.filterEmptyFacts(artifactWithPrecedence.artifactFacts.values().stream()).forEach(this::addFact);
        artifactWithPrecedence.artifactFlags.getRawContent().forEach(this::setFlag);
    }

    public String artifactAsCoordinate() {
        return this.getMainCoordinate().map(PackageURLFacade::canonicalize).orElse(this.prettyPrint());
    }

    @Override
    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Artifact");
        if (this.getAnalysisSource() != null) {
            stringBuilder.append(" (").append(this.getAnalysisSource()).append(")");
        }
        stringBuilder.append(": ");
        if ((this.artifactFacts.isEmpty() || this.artifactFacts.values().stream().allMatch(ArtifactFact::isEmpty)) && this.artifactFlags.isEmpty()) {
            stringBuilder.append("empty");
        } else {
            stringBuilder.append(this.filterEmptyFacts(this.artifactFacts.values().stream()).map(IPrettyPrintable::prettyPrint).sorted().collect(Collectors.joining("\n\t")));
            stringBuilder.append("\n\tFlags: ").append(this.artifactFlags.prettyPrint());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Artifact=");
        List<ArtifactIdentifier> artifactIdentifiers = this.getArtifactIdentifiers();
        if (artifactIdentifiers.size() > 0) {
            stringBuilder.append(artifactIdentifiers.stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]")));
        } else {
            stringBuilder.append("[no identifier]");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactCore)) {
            return false;
        }
        ArtifactCore that = (ArtifactCore)o;
        return Objects.equals(this.artifactFacts, that.artifactFacts) && Objects.equals(this.artifactFlags, that.artifactFlags) && Objects.equals(this.analysisSource, that.analysisSource);
    }

    public int hashCode() {
        return Objects.hash(this.artifactFacts, this.artifactFlags, this.analysisSource);
    }
}

