/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIdentifier;

public class ArtifactSelectorOrSet
implements ArtifactSelector {
    private final Set<? extends ArtifactSelector> selectors;

    public ArtifactSelectorOrSet(ArtifactSelector ... selectors) {
        this.selectors = new HashSet<ArtifactSelector>(Arrays.asList(selectors));
    }

    public ArtifactSelectorOrSet(Collection<? extends ArtifactSelector> selectors) {
        this.selectors = new HashSet<ArtifactSelector>(selectors);
    }

    @Override
    public boolean matches(Artifact artifact) {
        return this.selectors.stream().anyMatch(as -> as.matches(artifact));
    }

    @Override
    public boolean matches(ArtifactIdentifier artifactIdentifier) {
        return this.selectors.stream().allMatch(as -> as.matches(artifactIdentifier));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactSelectorOrSet that = (ArtifactSelectorOrSet)o;
        return Objects.equals(this.selectors, that.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.selectors);
    }

    public String toString() {
        if (this.selectors.size() == 1) {
            return this.selectors.stream().findFirst().map(Object::toString).orElse("");
        }
        return this.selectors.stream().map(Object::toString).collect(Collectors.joining(" OR ", "( ", " )"));
    }
}

