/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSchemaType;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.IArtifactBuilder;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFilename;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactMatchingMetadata;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactModificationStatus;
import org.eclipse.sw360.antenna.model.artifact.facts.CopyrightStatement;
import org.eclipse.sw360.antenna.model.artifact.facts.DeclaredLicenseInformation;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.license.FromXmlLicenseInformationBuilder;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.xml.generated.DeclaredLicense;
import org.eclipse.sw360.antenna.model.xml.generated.MatchState;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FromXmlArtifactBuilder
implements IArtifactBuilder {
    protected MavenCoordinatesBuilder mavenCoordinates;
    protected BundleCoordinatesBuilder bundleCoordinates;
    protected JavaScriptCoordinatesBuilder javaScriptCoordinates;
    protected DotNetCoordinatesBuilder dotNetCoordinates;
    protected String filename;
    protected String hash;
    protected DeclaredLicense declaredLicense;
    protected Boolean isProprietary;
    @XmlSchemaType(name="string")
    protected MatchState matchState;
    protected String copyrightStatement;
    protected String modificationStatus;

    @Override
    public Artifact build() {
        Artifact artifact = new Artifact("from XML").addFact(new ArtifactFilename(this.filename, this.hash)).addFact(new CopyrightStatement(this.copyrightStatement)).addFact(new ArtifactMatchingMetadata(this.matchState)).addFact(new ArtifactModificationStatus(this.modificationStatus));
        Stream.of(this.mavenCoordinates, this.bundleCoordinates, this.javaScriptCoordinates, this.dotNetCoordinates).filter(Objects::nonNull).map(CoordinatesBuilder::build).forEach(artifact::addCoordinate);
        if (this.declaredLicense != null) {
            LicenseInformation licenseInfo = ((FromXmlLicenseInformationBuilder.ILicenseInformationBuilder)this.declaredLicense.getLicenseInfo().getValue()).build();
            artifact.addFact(new DeclaredLicenseInformation(licenseInfo));
        }
        if (this.isProprietary != null) {
            artifact.setProprietary(this.isProprietary);
        }
        return artifact;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DotNetCoordinatesBuilder
    implements CoordinatesBuilder {
        protected String packageId;
        protected String version;

        public DotNetCoordinatesBuilder setPackageId(String value) {
            this.packageId = value;
            return this;
        }

        public DotNetCoordinatesBuilder setVersion(String value) {
            this.version = value;
            return this;
        }

        @Override
        public Coordinate build() {
            return new Coordinate("nuget", this.packageId, this.version);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class JavaScriptCoordinatesBuilder
    implements CoordinatesBuilder {
        protected String namespace;
        protected String packageName;
        protected String version;

        public JavaScriptCoordinatesBuilder setNamespace(String value) {
            this.namespace = value;
            return this;
        }

        public JavaScriptCoordinatesBuilder setPackageName(String value) {
            this.packageName = value;
            return this;
        }

        public JavaScriptCoordinatesBuilder setVersion(String value) {
            this.version = value;
            return this;
        }

        @Override
        public Coordinate build() {
            return new Coordinate("npm", this.namespace, this.packageName, this.version);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class BundleCoordinatesBuilder
    implements CoordinatesBuilder {
        protected String symbolicName;
        protected String bundleVersion;

        public void setSymbolicName(String value) {
            this.symbolicName = value;
        }

        public void setBundleVersion(String value) {
            this.bundleVersion = value;
        }

        @Override
        public Coordinate build() {
            return new Coordinate("p2", this.symbolicName, this.bundleVersion);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class MavenCoordinatesBuilder
    implements CoordinatesBuilder {
        private String artifactId;
        private String groupId;
        private String version;

        public MavenCoordinatesBuilder setArtifactId(String value) {
            this.artifactId = value;
            return this;
        }

        public MavenCoordinatesBuilder setGroupId(String value) {
            this.groupId = value;
            return this;
        }

        public MavenCoordinatesBuilder setVersion(String value) {
            this.version = value;
            return this;
        }

        @Override
        public Coordinate build() {
            return new Coordinate("maven", this.groupId, this.artifactId, this.version);
        }
    }

    public static interface CoordinatesBuilder {
        public Coordinate build();
    }
}

