/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact.facts;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFactWithPayload;

public class ArtifactSoftwareHeritageID
extends ArtifactFactWithPayload<String> {
    private ArtifactSoftwareHeritageID(String softwareHeritageID) {
        super(softwareHeritageID);
    }

    @Override
    public String getFactContentName() {
        return "Software Heritage URL";
    }

    @Override
    public Class<? extends ArtifactFact> getKey() {
        return ArtifactSoftwareHeritageID.class;
    }

    public static String getExpectedFormat() {
        return "swh:1:rel:*";
    }

    public static class Builder {
        private String softwareHeritageID;

        public Builder(String softwareHeritageID) {
            this.softwareHeritageID = softwareHeritageID;
        }

        public ArtifactSoftwareHeritageID build() throws IllegalArgumentException {
            if (this.softwareHeritageID == null || !this.isValid(this.softwareHeritageID)) {
                throw new IllegalArgumentException(this.softwareHeritageID + " does not match expected format for SoftwareHeritageID: " + ArtifactSoftwareHeritageID.getExpectedFormat());
            }
            return new ArtifactSoftwareHeritageID(this.softwareHeritageID);
        }

        private boolean isValid(String swhID) {
            List objectTypes = Stream.of("snp", "rel", "rev", "dir", "cnt").collect(Collectors.toList());
            String[] swhElements = swhID.split(":");
            return swhElements.length == 4 && swhElements[0].equals("swh") && this.isParsableInteger(swhElements[1]) && objectTypes.contains(swhElements[2]) && swhElements[3].length() == 40;
        }

        private boolean isParsableInteger(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

