/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact.facts;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;

public class ArtifactVcsInfo
implements ArtifactFact<ArtifactVcsInfo> {
    private final VcsInfo vcsInfo;

    public ArtifactVcsInfo(String type, String url, String revision) {
        this(new VcsInfo(type, url, revision));
    }

    public ArtifactVcsInfo(VcsInfo vcsInfo) {
        this.vcsInfo = vcsInfo;
    }

    public VcsInfo getVcsInfo() {
        return this.vcsInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactVcsInfo that = (ArtifactVcsInfo)o;
        return Objects.equals(this.vcsInfo, that.vcsInfo);
    }

    public String toString() {
        return Optional.ofNullable(this.vcsInfo).map(Objects::toString).orElse("EMPTY");
    }

    public int hashCode() {
        return Objects.hash(this.vcsInfo);
    }

    @Override
    public String getFactContentName() {
        return "VCS Information";
    }

    @Override
    public boolean isEmpty() {
        return this.vcsInfo == null;
    }

    @Override
    public String prettyPrint() {
        return "Set ArtifactVcsInfo to " + this.toString();
    }

    public static class VcsInfo {
        private final String type;
        private final String url;
        private final String revision;

        public VcsInfo(String type, String url, String revision) {
            this.type = type;
            this.url = url;
            this.revision = revision;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getRevision() {
            return this.revision;
        }

        public boolean isEmpty() {
            return this.type == null && this.url == null && this.revision == null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VcsInfo vcsInfo = (VcsInfo)o;
            return Objects.equals(this.type, vcsInfo.type) && Objects.equals(this.url, vcsInfo.url) && Objects.equals(this.revision, vcsInfo.revision);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.url, this.revision);
        }

        public String toString() {
            return "VcsInfo{type='" + this.type + '\'' + ", url='" + this.url + '\'' + ", revision='" + this.revision + '\'' + '}';
        }
    }
}

