/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseOperator;
import org.eclipse.sw360.antenna.model.license.LicenseStatement;
import org.eclipse.sw360.antenna.model.license.WithLicense;

public class FromXmlLicenseInformationBuilder {

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class WithLicenseBuilder
    implements ILicenseInformationBuilder {
        private LicenseBuilder license;
        private LicenseBuilder exception;

        public void setLicense(LicenseBuilder license) {
            this.license = license;
        }

        public void setException(LicenseBuilder exception) {
            this.exception = exception;
        }

        @Override
        public LicenseInformation build() {
            return new WithLicense((License)this.license.build(), (License)this.exception.build());
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LicenseBuilder
    implements ILicenseInformationBuilder {
        @XmlElements(value={@XmlElement(name="id"), @XmlElement(name="name")})
        private String id;
        @XmlElements(value={@XmlElement(name="commonName"), @XmlElement(name="longName")})
        private String commonName;
        private String text;
        private Map<String, String> properties = new HashMap<String, String>();

        public void setId(String id) {
            this.id = id;
        }

        public void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public LicenseInformation build() {
            return new License(this.id, this.commonName, this.text, this.properties);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="licenseStatement", propOrder={"licenseInfo"})
    public static class LicenseStatementBuilder
    implements ILicenseInformationBuilder {
        @XmlElementRef(name="licenseInfo", type=JAXBElement.class)
        private List<JAXBElement<? extends ILicenseInformationBuilder>> licenseInfo;
        @XmlAttribute(name="op")
        private LicenseOperator op;

        public void setLicenseInfo(List<JAXBElement<? extends ILicenseInformationBuilder>> value) {
            this.licenseInfo = value;
        }

        public void setOp(LicenseOperator value) {
            this.op = value;
        }

        @Override
        public LicenseInformation build() {
            LicenseStatement license = new LicenseStatement();
            license.setLicenses(this.licenseInfo.stream().map(l -> (ILicenseInformationBuilder)l.getValue()).map(ILicenseInformationBuilder::build).collect(Collectors.toList()));
            license.setOp(this.op);
            return license;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="licenseInformation")
    public static abstract class AbstractLicenseInformation {
        public abstract String evaluate();

        public abstract boolean isEmpty();

        public abstract List<License> getLicenses();
    }

    public static interface ILicenseInformationBuilder {
        public LicenseInformation build();
    }
}

