/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;

public class License
implements LicenseInformation {
    private static final String THREAT_GROUP_KEY = "threatGroup";
    private static final String CLASSIFICATION_KEY = "classification";
    private String id;
    private String commonName;
    private String text;
    private Map<String, String> properties;

    public License() {
        this.properties = new HashMap<String, String>();
    }

    public License(String id) {
        this(id, "", "", new HashMap<String, String>());
    }

    public License(String id, String commonName, String text) {
        this(id, commonName, text, new HashMap<String, String>());
    }

    public License(String id, String commonName, String text, Map<String, String> properties) {
        this.id = id;
        this.commonName = commonName;
        this.text = text;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String property) {
        this.properties.put(key, property);
    }

    public void setThreatGroup(String value) {
        this.setProperty(THREAT_GROUP_KEY, value);
    }

    public Optional<String> getThreatGroup() {
        return this.getProperty(THREAT_GROUP_KEY);
    }

    public void setClassification(String value) {
        this.setProperty(CLASSIFICATION_KEY, value);
    }

    public Optional<String> getClassification() {
        return this.getProperty(CLASSIFICATION_KEY);
    }

    public Optional<String> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    @Override
    public String evaluate() {
        return this.getId();
    }

    @Override
    public boolean isEmpty() {
        return this.id == null;
    }

    @Override
    public List<License> getLicenses() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return Objects.equals(this.id, license.id) && Objects.equals(this.commonName, license.commonName) && Objects.equals(this.text, license.text) && Objects.equals(this.properties, license.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.commonName, this.text, this.properties);
    }

    public String toString() {
        return this.evaluate();
    }
}

