/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseOperator;

public class LicenseStatement
implements LicenseInformation {
    private List<LicenseInformation> licenses;
    private LicenseOperator op;

    public LicenseStatement() {
        this(new ArrayList<LicenseInformation>(), null);
    }

    public LicenseStatement(List<LicenseInformation> licenses, LicenseOperator op) {
        this.licenses = licenses;
        this.op = op;
    }

    public void setLicenses(List<LicenseInformation> licenses) {
        this.licenses = licenses;
    }

    public LicenseOperator getOp() {
        return this.op;
    }

    public void setOp(LicenseOperator operator) {
        this.op = operator;
    }

    public boolean addLicenseInformation(LicenseInformation license) {
        return this.licenses.add(license);
    }

    @Override
    public String evaluate() {
        if (this.isEmpty()) {
            return "";
        }
        return "( " + this.licenses.stream().map(LicenseInformation::evaluate).collect(Collectors.joining(" " + this.op.toString() + " ")) + " )";
    }

    @Override
    public boolean isEmpty() {
        return this.licenses == null || this.licenses.isEmpty() || this.licenses.stream().allMatch(LicenseInformation::isEmpty);
    }

    @Override
    public List<License> getLicenses() {
        if (this.licenses == null || this.isEmpty()) {
            this.licenses = new ArrayList<LicenseInformation>();
        }
        return this.licenses.stream().map(LicenseInformation::getLicenses).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseStatement that = (LicenseStatement)o;
        return Objects.equals(this.licenses, that.licenses) && this.op == that.op;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.licenses, this.op});
    }

    public String toString() {
        return this.evaluate();
    }
}

