/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;

public class WithLicense
implements LicenseInformation {
    private License license;
    private License exception;

    public WithLicense() {
        this(new License(), new License());
    }

    public WithLicense(License license, License exception) {
        this.license = license;
        this.exception = exception;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public License getException() {
        return this.exception;
    }

    public void setException(License exception) {
        this.exception = exception;
    }

    @Override
    public String evaluate() {
        return this.license.getId() + " WITH " + this.exception.getId();
    }

    @Override
    public boolean isEmpty() {
        return this.license.isEmpty() && this.exception.isEmpty();
    }

    @Override
    public List<License> getLicenses() {
        return Stream.of(this.license, this.exception).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WithLicense that = (WithLicense)o;
        return Objects.equals(this.license, that.license) && Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(this.license, this.exception);
    }

    public String toString() {
        return this.evaluate();
    }
}

