/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.eclipse.sw360.antenna.model.reporting.ProcessingMessageWithPayload;

public class IncompleteSourcesFailure
extends ProcessingMessageWithPayload {
    private List<String> missingSources = new ArrayList<String>();

    public IncompleteSourcesFailure(String message) {
        super(MessageType.INCOMPLETE_SOURCES, message);
    }

    public IncompleteSourcesFailure(String identifier, String message) {
        super(MessageType.INCOMPLETE_SOURCES, identifier, message);
    }

    public void addMissingSources(String className) {
        this.missingSources.add(className);
    }

    public void addMissingSources(Collection<String> classNames) {
        this.missingSources.addAll(classNames);
    }

    @Override
    public List<String> getPayload() {
        return this.missingSources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IncompleteSourcesFailure that = (IncompleteSourcesFailure)o;
        return Objects.equals(this.missingSources, that.missingSources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.missingSources);
    }
}

