/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.util;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.facts.ConfiguredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.DeclaredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ObservedLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.OverriddenLicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseOperator;
import org.eclipse.sw360.antenna.model.license.LicenseStatement;

public class ArtifactLicenseUtils {
    private ArtifactLicenseUtils() {
    }

    public static LicenseInformation getFinalLicenses(Artifact artifact) {
        Optional configured = artifact.askForGet(ConfiguredLicenseInformation.class);
        if (configured.isPresent()) {
            return (LicenseInformation)configured.get();
        }
        Optional overridden = artifact.askForGet(OverriddenLicenseInformation.class);
        if (overridden.isPresent()) {
            return (LicenseInformation)overridden.get();
        }
        Optional declared = artifact.askForGet(DeclaredLicenseInformation.class);
        Optional observed = artifact.askForGet(ObservedLicenseInformation.class);
        if (declared.isPresent() && observed.isPresent()) {
            String declaredLicenseRepresentation = Optional.ofNullable(((LicenseInformation)declared.get()).evaluate()).orElse("");
            String observedLicenseRepresentation = Optional.ofNullable(((LicenseInformation)observed.get()).evaluate()).orElse("");
            if (observedLicenseRepresentation.contains(declaredLicenseRepresentation) && !observedLicenseRepresentation.contains(" OR ")) {
                return (LicenseInformation)observed.get();
            }
            LicenseStatement effective = new LicenseStatement();
            effective.setLicenses(Stream.of((LicenseInformation)declared.get(), (LicenseInformation)observed.get()).collect(Collectors.toList()));
            effective.setOp(LicenseOperator.AND);
            return effective;
        }
        return declared.orElse(observed.orElse(new LicenseStatement()));
    }
}

