/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.ort.workflow.analyzers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.sw360.antenna.api.workflow.ManualAnalyzer;
import org.eclipse.sw360.antenna.api.workflow.WorkflowStepResult;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.ort.resolver.OrtResultArtifactResolver;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.CuratedPackage;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.OutputFormatKt;
import org.ossreviewtoolkit.model.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/eclipse/sw360/antenna/ort/workflow/analyzers/OrtResultAnalyzer;", "Lorg/eclipse/sw360/antenna/api/workflow/ManualAnalyzer;", "()V", "createArtifactList", "", "Lorg/eclipse/sw360/antenna/model/artifact/Artifact;", "ortResultFile", "Ljava/io/File;", "getName", "", "yield", "Lorg/eclipse/sw360/antenna/api/workflow/WorkflowStepResult;", "Companion", "ort-module"})
public final class OrtResultAnalyzer
extends ManualAnalyzer {
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    public WorkflowStepResult yield() {
        File file = this.componentInfoFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"componentInfoFile");
        return new WorkflowStepResult(this.createArtifactList(file));
    }

    @NotNull
    public String getName() {
        return "OrtResult";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Artifact> createArtifactList(@NotNull File ortResultFile) throws IOException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)ortResultFile, (String)"ortResultFile");
        LOGGER.debug("Creating artifact list from ORT result file '" + ortResultFile + "'.");
        File $this$readValue$iv = ortResultFile;
        boolean $i$f$readValue = false;
        ObjectMapper $this$readValue$iv$iv = OutputFormatKt.mapper((File)$this$readValue$iv);
        boolean $i$f$readValue22 = false;
        File file = $this$readValue$iv;
        ObjectMapper objectMapper = $this$readValue$iv$iv;
        boolean $i$f$jacksonTypeRef = false;
        TypeReference typeReference = (TypeReference)new TypeReference<OrtResult>(){};
        OrtResult result = (OrtResult)objectMapper.readValue(file, typeReference);
        if (result.getAnalyzer() == null) {
            throw (Throwable)new IOException("No analyzer run found in ORT result file.");
        }
        OrtResultArtifactResolver resolver = new OrtResultArtifactResolver(result);
        Iterable $this$map$iv = OrtResult.getPackages$default((OrtResult)result, (boolean)false, (int)1, null);
        boolean $i$f$map = false;
        Iterable $i$f$readValue22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$pkg$_u24__u24;
            CuratedPackage curatedPackage = (CuratedPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Package pkg = $dstr$pkg$_u24__u24.component1();
            Artifact artifact = resolver.apply(pkg);
            collection.add(artifact);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public OrtResultAnalyzer() {
        this.workflowStepOrder = (short)700;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(OrtResultAnalyzer.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/eclipse/sw360/antenna/ort/workflow/analyzers/OrtResultAnalyzer$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ort-module"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

