/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.ort.workflow.processors.enricher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFilename;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceFile;
import org.eclipse.sw360.antenna.ort.utils.ArtifactToPackageMapper;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.downloader.DownloadException;
import org.ossreviewtoolkit.downloader.Downloader;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.utils.ArchiveUtilsKt;
import org.ossreviewtoolkit.utils.ExtensionsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/eclipse/sw360/antenna/ort/workflow/processors/enricher/OrtDownloaderProcessorImpl;", "", "sourcesZipDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "process", "", "Lorg/eclipse/sw360/antenna/model/artifact/Artifact;", "intermediates", "Companion", "ort-module"})
public final class OrtDownloaderProcessorImpl {
    private final File sourcesZipDirectory;
    private static final Logger LOGGER;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Artifact> process(@NotNull Collection<Artifact> intermediates) {
        Object it;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(intermediates, (String)"intermediates");
        Iterable $this$filterNot$iv = intermediates;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Artifact)element$iv$iv;
            boolean bl22 = false;
            Optional optional = it.getSourceFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"it.sourceFile");
            if (optional.isPresent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Artifact artifact = (Artifact)element$iv;
            boolean bl = false;
            Package pkg = new ArtifactToPackageMapper().apply(artifact);
            it = artifact.askFor(ArtifactCoordinates.class);
            boolean bl22 = false;
            boolean bl3 = false;
            Object fact = it;
            boolean bl4 = false;
            Object object2 = fact;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"fact");
            Object object3 = ((Optional)object2).isPresent() ? it : null;
            if (object3 == null || (object3 = (ArtifactCoordinates)((Optional)object3).get()) == null || (object3 = object3.getMainCoordinate()) == null || (object3 = object3.canonicalize()) == null) {
                it = artifact.askFor(ArtifactFilename.class);
                bl22 = false;
                bl3 = false;
                fact = it;
                boolean bl5 = false;
                Object object4 = fact;
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"fact");
                Object object5 = ((Optional)object4).isPresent() ? it : null;
                if (object5 != null) {
                    it = object5;
                    bl22 = false;
                    bl3 = false;
                    Object filename = it;
                    boolean bl6 = false;
                    Object t = ((Optional)filename).get();
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"filename.get()");
                    Optional optional = ((ArtifactFilename)t).getBestFilenameEntryGuess();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Optional filenameEntry = optional;
                    boolean bl9 = false;
                    Optional optional2 = filenameEntry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)optional2, (String)"filenameEntry");
                    Optional optional3 = optional2.isPresent() ? optional : null;
                    object3 = optional3 != null && (optional3 = (ArtifactFilename.ArtifactFilenameEntry)optional3.get()) != null ? optional3.getFilename() : null;
                } else {
                    object3 = object = null;
                }
            }
            if (object3 == null) {
                object = "unknown";
            }
            Object name = object;
            try {
                Downloader.DownloadResult downloadResult;
                LOGGER.debug("Download sources via ORT Downloader for '" + (String)name + '\'');
                File bl22 = FilesKt.createTempDir$default((String)"ortDownloaderDirectory", null, null, (int)6, null);
                bl3 = false;
                boolean bl10 = false;
                File it2 = bl22;
                boolean bl11 = false;
                it2.deleteOnExit();
                File ortDownloadDirectory = bl22;
                if (StringsKt.startsWith$default((String)pkg.getVcsProcessed().getUrl(), (String)"ssh://git@github.com", (boolean)false, (int)2, null)) {
                    String newUrl = StringsKt.replace$default((String)pkg.getVcsProcessed().getUrl(), (String)"ssh://git@github.com", (String)"https://github.com", (boolean)false, (int)4, null);
                    pkg = Package.copy$default((Package)pkg, null, null, null, null, null, null, null, null, null, null, (VcsInfo)VcsInfo.copy$default((VcsInfo)pkg.getVcsProcessed(), null, (String)newUrl, null, null, null, (int)29, null), (int)1023, null);
                }
                if (!(downloadResult = Downloader.download$default((Downloader)new Downloader(), (Package)pkg, (File)ortDownloadDirectory, (boolean)false, (int)4, null)).getDownloadDirectory().isDirectory()) continue;
                File zipFile = new File(this.sourcesZipDirectory, ExtensionsKt.encodeOrUnknown((String)pkg.getId().getName()) + '-' + ExtensionsKt.encodeOrUnknown((String)pkg.getId().getVersion()) + ".zip");
                LOGGER.debug("Pack source directory '" + downloadResult.getDownloadDirectory().getAbsolutePath() + "' to " + '\'' + zipFile.getAbsolutePath() + '.');
                ArchiveUtilsKt.packZip$default((File)downloadResult.getDownloadDirectory(), (File)zipFile, null, (boolean)false, null, (int)14, null);
                if (!zipFile.isFile()) continue;
                artifact.addFact((ArtifactFact)new ArtifactSourceFile(zipFile.toPath()));
            }
            catch (DownloadException e) {
                LOGGER.warn("Failed to download sources for '" + (String)name + '\'');
            }
        }
        return intermediates;
    }

    public OrtDownloaderProcessorImpl(@NotNull File sourcesZipDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)sourcesZipDirectory, (String)"sourcesZipDirectory");
        this.sourcesZipDirectory = sourcesZipDirectory;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(OrtDownloaderProcessorImpl.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/eclipse/sw360/antenna/ort/workflow/processors/enricher/OrtDownloaderProcessorImpl$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ort-module"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

