/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.ort.utils;

import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceUrl;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactVcsInfo;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lorg/eclipse/sw360/antenna/ort/utils/ArtifactToPackageMapper;", "Ljava/util/function/Function;", "Lorg/eclipse/sw360/antenna/model/artifact/Artifact;", "Lorg/ossreviewtoolkit/model/Package;", "()V", "apply", "artifact", "mapIdentifier", "Lorg/ossreviewtoolkit/model/Identifier;", "mapSourceRemoteArtifact", "Lorg/ossreviewtoolkit/model/RemoteArtifact;", "mapToVcsInfo", "Lorg/ossreviewtoolkit/model/VcsInfo;", "ort-module"})
public final class ArtifactToPackageMapper
implements Function<Artifact, Package> {
    @Override
    @NotNull
    public Package apply(@NotNull Artifact artifact) {
        VcsInfo vcsInfo;
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        Identifier identifier = this.mapIdentifier(artifact);
        if (identifier == null) {
            identifier = Identifier.EMPTY;
        }
        SortedSet sortedSet = SetsKt.sortedSetOf((Object[])new String[0]);
        RemoteArtifact remoteArtifact = this.mapSourceRemoteArtifact(artifact);
        if (remoteArtifact == null) {
            remoteArtifact = RemoteArtifact.EMPTY;
        }
        if ((vcsInfo = this.mapToVcsInfo(artifact)) == null) {
            vcsInfo = VcsInfo.EMPTY;
        }
        return new Package(identifier, null, sortedSet, null, null, "", "", RemoteArtifact.EMPTY, remoteArtifact, vcsInfo, null, 1050, null);
    }

    private final Identifier mapIdentifier(Artifact artifact) {
        Identifier identifier;
        Optional optional = artifact.askFor(ArtifactCoordinates.class);
        boolean bl = false;
        boolean bl2 = false;
        Optional it = optional;
        boolean bl3 = false;
        Optional optional2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)optional2, (String)"it");
        Optional optional3 = optional2.isPresent() ? optional : null;
        if (optional3 != null) {
            String string;
            optional = optional3;
            bl = false;
            bl2 = false;
            it = optional;
            boolean bl4 = false;
            Object t = it.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"it.get()");
            ArtifactCoordinates coordinates = (ArtifactCoordinates)t;
            Coordinate coordinate = coordinates.getMainCoordinate();
            Intrinsics.checkExpressionValueIsNotNull((Object)coordinate, (String)"coordinates.mainCoordinate");
            String string2 = coordinate.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"coordinates.mainCoordinate.type");
            String string3 = string2;
            boolean bl5 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            String type = string5;
            Coordinate coordinate2 = coordinates.getMainCoordinate();
            Intrinsics.checkExpressionValueIsNotNull((Object)coordinate2, (String)"coordinates.mainCoordinate");
            String string6 = coordinate2.getNamespace();
            if (string6 == null) {
                string6 = "";
            }
            String namespace = string6;
            Coordinate coordinate3 = coordinates.getMainCoordinate();
            Intrinsics.checkExpressionValueIsNotNull((Object)coordinate3, (String)"coordinates.mainCoordinate");
            String string7 = coordinate3.getName();
            if (string7 == null) {
                string7 = "";
            }
            String name = string7;
            Coordinate coordinate4 = coordinates.getMainCoordinate();
            Intrinsics.checkExpressionValueIsNotNull((Object)coordinate4, (String)"coordinates.mainCoordinate");
            String string8 = coordinate4.getVersion();
            if (string8 == null) {
                string8 = "";
            }
            String version = string8;
            switch (type) {
                case "maven": {
                    string = "Maven";
                    break;
                }
                case "npm": {
                    string = "NPM";
                    break;
                }
                case "nuget": {
                    string = "nuget";
                    break;
                }
                default: {
                    string = "Unmanaged";
                }
            }
            String ortType = string;
            identifier = new Identifier(ortType, namespace, name, version);
        } else {
            identifier = null;
        }
        return identifier;
    }

    private final VcsInfo mapToVcsInfo(Artifact artifact) {
        VcsInfo vcsInfo;
        Optional optional = artifact.askFor(ArtifactVcsInfo.class);
        boolean bl = false;
        boolean bl2 = false;
        Optional it = optional;
        boolean bl3 = false;
        Optional optional2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)optional2, (String)"it");
        Optional optional3 = optional2.isPresent() ? optional : null;
        if (optional3 != null) {
            ArtifactVcsInfo.VcsInfo vcsInfo2;
            optional = optional3;
            bl = false;
            bl2 = false;
            it = optional;
            boolean bl4 = false;
            Object t = it.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"it.get()");
            ArtifactVcsInfo.VcsInfo vcsInfo3 = vcsInfo2 = ((ArtifactVcsInfo)t).getVcsInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsInfo3, (String)"vcsInfo");
            String string = vcsInfo3.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"vcsInfo.type");
            VcsType vcsType = new VcsType(string);
            String string2 = vcsInfo2.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"vcsInfo.url");
            String string3 = vcsInfo2.getRevision();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"vcsInfo.revision");
            vcsInfo = new VcsInfo(vcsType, string2, string3, null, null, 24, null);
        } else {
            vcsInfo = null;
        }
        return vcsInfo;
    }

    private final RemoteArtifact mapSourceRemoteArtifact(Artifact artifact) {
        RemoteArtifact remoteArtifact;
        Optional optional = artifact.askForGet(ArtifactSourceUrl.class);
        boolean bl = false;
        boolean bl2 = false;
        Optional it = optional;
        boolean bl3 = false;
        Optional optional2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)optional2, (String)"it");
        Optional optional3 = optional2.isPresent() ? optional : null;
        if (optional3 != null) {
            optional = optional3;
            bl = false;
            bl2 = false;
            it = optional;
            boolean bl4 = false;
            Object t = it.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"it.get()");
            remoteArtifact = RemoteArtifact.copy$default((RemoteArtifact)RemoteArtifact.EMPTY, (String)((String)t), null, (int)2, null);
        } else {
            remoteArtifact = null;
        }
        return remoteArtifact;
    }
}

