/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.ort.workflow.processors.enricher;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.ort.workflow.processors.enricher.OrtDownloaderProcessorImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/eclipse/sw360/antenna/ort/workflow/processors/enricher/OrtDownloaderProcessor;", "Lorg/eclipse/sw360/antenna/api/workflow/AbstractProcessor;", "()V", "sourcesZipDirectory", "Ljava/io/File;", "configure", "", "configMap", "", "", "process", "", "Lorg/eclipse/sw360/antenna/model/artifact/Artifact;", "intermediates", "Companion", "ort-module"})
public final class OrtDownloaderProcessor
extends AbstractProcessor {
    private File sourcesZipDirectory;
    @NotNull
    public static final String ORT_DOWNLOADER_DIR = "ort-downloader-result";
    public static final Companion Companion = new Companion(null);

    public void configure(@NotNull Map<String, String> configMap) {
        Intrinsics.checkParameterIsNotNull(configMap, (String)"configMap");
        AntennaContext antennaContext = this.context;
        Intrinsics.checkExpressionValueIsNotNull((Object)antennaContext, (String)"context");
        ToolConfiguration toolConfiguration = antennaContext.getToolConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)toolConfiguration, (String)"context.toolConfiguration");
        File file = toolConfiguration.getAntennaTargetDirectory().resolve(ORT_DOWNLOADER_DIR).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.toolConfiguratio\u2026_DOWNLOADER_DIR).toFile()");
        File file2 = this.sourcesZipDirectory = file;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourcesZipDirectory");
        }
        if (!file2.isDirectory()) {
            File file3 = this.sourcesZipDirectory;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sourcesZipDirectory");
            }
            if (!file3.mkdirs()) {
                StringBuilder stringBuilder = new StringBuilder().append("Failed to create directory '");
                File file4 = this.sourcesZipDirectory;
                if (file4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sourcesZipDirectory");
                }
                throw (Throwable)new ConfigurationException(stringBuilder.append(file4.getAbsolutePath()).append("' ").append("for ORT Downloader result. ").toString());
            }
        }
    }

    @NotNull
    public Collection<Artifact> process(@NotNull Collection<Artifact> intermediates) {
        Intrinsics.checkParameterIsNotNull(intermediates, (String)"intermediates");
        File file = this.sourcesZipDirectory;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourcesZipDirectory");
        }
        return new OrtDownloaderProcessorImpl(file).process(intermediates);
    }

    public OrtDownloaderProcessor() {
        this.workflowStepOrder = (short)350;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/eclipse/sw360/antenna/ort/workflow/processors/enricher/OrtDownloaderProcessor$Companion;", "", "()V", "ORT_DOWNLOADER_DIR", "", "ort-module"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

