/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;
import org.eclipse.sw360.antenna.policy.engine.PolicyEngine;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyEngine.class);

    public static Optional<PolicyViolation> artifactRaisesPolicyViolation(Rule rule, ThirdPartyArtifact ... failingArtifacts) {
        LOGGER.debug(String.format("Artifacts %s raises a policy violation for rule %s", RuleUtils.getArtifactString(failingArtifacts), rule.getId()));
        return Optional.of(new PolicyViolation(rule, Arrays.asList(failingArtifacts)));
    }

    public static Optional<PolicyViolation> artifactAppliesToRule(Rule rule, ThirdPartyArtifact ... cleanArtifacts) {
        LOGGER.debug(String.format("Artifacts %s are clean for rule %s", RuleUtils.getArtifactString(cleanArtifacts), rule.getId()));
        return Optional.empty();
    }

    private static String getArtifactString(ThirdPartyArtifact[] failingArtifacts) {
        return Arrays.asList(failingArtifacts).stream().map(ThirdPartyArtifact::getCoordinates).flatMap(Collection::stream).map(PackageURLFacade::canonicalize).collect(Collectors.joining(" : ", "[ ", " ]"));
    }
}

