/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.engine;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleExecutor;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

class SingleArtifactExecutor
implements RuleExecutor {
    private final Collection<SingleArtifactRule> rules;

    SingleArtifactExecutor(Collection<SingleArtifactRule> rules) {
        this.rules = rules;
    }

    @Override
    public Collection<PolicyViolation> executeRules(Collection<ThirdPartyArtifact> thirdPartyArtifacts) {
        return this.rules.parallelStream().map(rule -> this.executeRuleOnElements((SingleArtifactRule)rule, thirdPartyArtifacts)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<PolicyViolation> executeRuleOnElements(SingleArtifactRule rule, Collection<ThirdPartyArtifact> thirdPartyArtifacts) {
        return thirdPartyArtifacts.stream().map(artifact -> rule.evaluate((ThirdPartyArtifact)artifact)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Collection<Ruleset> getRulesets() {
        return this.rules.stream().map(Rule::getRuleset).collect(Collectors.toSet());
    }
}

