/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.workflow.processors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.IPolicyEvaluation;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.WorkflowStepResult;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.policy.engine.PolicyEngine;
import org.eclipse.sw360.antenna.policy.engine.PolicyEngineConfigurator;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.workflow.processors.AntennaArtifact;
import org.eclipse.sw360.antenna.workflow.stubs.AbstractComplianceChecker;

public class PolicyEngineProcessor
extends AbstractComplianceChecker {
    private PolicyEngine policyEngine;
    private static final String RULESET_PROP = "ruleset.classes";

    public PolicyEngineProcessor() {
        this.workflowStepOrder = (short)21000;
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        String rulesetClasses = this.getConfigValue(RULESET_PROP, configMap).trim();
        Collection rulesetClassesList = Arrays.stream(rulesetClasses.split(",")).map(String::trim).collect(Collectors.toList());
        try {
            this.policyEngine = PolicyEngineConfigurator.configure(rulesetClassesList);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new ConfigurationException("Could not initialize Policy Engine!", (Throwable)e);
        }
    }

    public WorkflowStepResult postProcessResult(WorkflowStepResult result) {
        WorkflowStepResult pResult = super.postProcessResult(result);
        pResult.addAdditionalReportComment("Evaluated with " + this.getRulesetDescription());
        return pResult;
    }

    public IPolicyEvaluation evaluate(Collection<Artifact> artifacts) {
        Collection polengArtifacts = artifacts.stream().map(AntennaArtifact::new).collect(Collectors.toList());
        return new PolicyEvaluation(this.policyEngine.evaluate(polengArtifacts));
    }

    public String getRulesetDescription() {
        return this.policyEngine.getRulesets().stream().map(this::prepareRulesetInfo).collect(Collectors.joining(", "));
    }

    private String prepareRulesetInfo(Ruleset ruleset) {
        return String.format("%s [%s]", ruleset.getName(), ruleset.getVersion());
    }

    private static class AntennaEvaluationResult
    implements IEvaluationResult {
        private final PolicyViolation violation;

        AntennaEvaluationResult(PolicyViolation violation) {
            this.violation = violation;
        }

        public String getId() {
            return this.violation.getId();
        }

        public String getDescription() {
            return this.violation.getDescription();
        }

        public IEvaluationResult.Severity getSeverity() {
            switch (this.violation.getSeverity()) {
                case WARN: {
                    return IEvaluationResult.Severity.INFO;
                }
                case SEVERE: {
                    return IEvaluationResult.Severity.WARN;
                }
                case CRITICAL: {
                    return IEvaluationResult.Severity.FAIL;
                }
            }
            throw new IllegalStateException("Programming Error: No other case possible in enum");
        }

        public Set<Artifact> getFailedArtifacts() {
            return this.violation.getFailingArtifacts().stream().map(element -> ((AntennaArtifact)element).getArtifact()).collect(Collectors.toSet());
        }
    }

    private static class PolicyEvaluation
    implements IPolicyEvaluation {
        private final Set<IEvaluationResult> evalResults;

        PolicyEvaluation(Collection<PolicyViolation> data) {
            this.evalResults = data.stream().map(AntennaEvaluationResult::new).collect(Collectors.toSet());
        }

        public Set<IEvaluationResult> getEvaluationResults() {
            return this.evalResults;
        }
    }
}

