/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.engine;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.policy.engine.CompareArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleExecutor;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

class CompareArtifactExecutor
implements RuleExecutor {
    private final Collection<CompareArtifactRule> rules;

    public CompareArtifactExecutor(Collection<CompareArtifactRule> rules) {
        this.rules = rules;
    }

    @Override
    public Collection<PolicyViolation> executeRules(Collection<ThirdPartyArtifact> thirdPartyArtifacts) {
        return this.rules.parallelStream().map(rule -> this.executeRuleOnArtifacts((CompareArtifactRule)rule, thirdPartyArtifacts)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<PolicyViolation> executeRuleOnArtifacts(CompareArtifactRule rule, Collection<ThirdPartyArtifact> thirdPartyArtifacts) {
        return thirdPartyArtifacts.stream().map(artifact -> this.findViolationsForLeftHandSide(rule, (ThirdPartyArtifact)artifact, thirdPartyArtifacts)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private Collection<PolicyViolation> findViolationsForLeftHandSide(CompareArtifactRule rule, ThirdPartyArtifact leftHandSide, Collection<ThirdPartyArtifact> rightHandSides) {
        return rightHandSides.stream().filter(rightHandSide -> !rightHandSide.equals(leftHandSide)).map(rightHandSide -> rule.evaluate(leftHandSide, (ThirdPartyArtifact)rightHandSide)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Collection<Ruleset> getRulesets() {
        return this.rules.stream().map(Rule::getRuleset).collect(Collectors.toSet());
    }
}

