/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.policy.engine.CompareArtifactExecutor;
import org.eclipse.sw360.antenna.policy.engine.CompareArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.PolicyEngine;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleExecutor;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactExecutor;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;

public class PolicyEngineConfigurator {
    private static final String SINGLE_ARTIFACT_EXECUTOR = SingleArtifactExecutor.class.getName();
    private static final String COMPARE_ARTIFACT_EXECUTOR = CompareArtifactExecutor.class.getName();

    public static PolicyEngine configure(Collection<String> rulesetRefs) throws IllegalArgumentException {
        if (rulesetRefs == null || rulesetRefs.isEmpty()) {
            throw new IllegalArgumentException("Configuration Error: No rule set reference given");
        }
        Map<String, Set<Rule>> executorToRuleMapping = rulesetRefs.stream().map(PolicyEngineConfigurator::createRuleset).map(Ruleset::getRules).flatMap(Collection::stream).map(PolicyEngineConfigurator::mapRuleToExecutor).collect(Collectors.groupingBy(RuleToExecutor::getExecutorClass, Collectors.mapping(RuleToExecutor::getRule, Collectors.toSet())));
        PolicyEngine resultEngine = new PolicyEngine(PolicyEngineConfigurator.createExecutors(executorToRuleMapping));
        return resultEngine;
    }

    private static Ruleset createRuleset(String ruleClassRef) throws IllegalArgumentException {
        try {
            return (Ruleset)Class.forName(ruleClassRef).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Configuration Error: Instantiation of rule type failed: " + ruleClassRef, e);
        }
    }

    private static RuleToExecutor mapRuleToExecutor(Rule rule) {
        if (rule instanceof SingleArtifactRule) {
            return new RuleToExecutor(rule, SINGLE_ARTIFACT_EXECUTOR);
        }
        if (rule instanceof CompareArtifactRule) {
            return new RuleToExecutor(rule, COMPARE_ARTIFACT_EXECUTOR);
        }
        throw new IllegalStateException("Programming Error: Rule type defined without Executor: " + rule.getClass().getName());
    }

    private static Collection<RuleExecutor> createExecutors(Map<String, Set<Rule>> executorToRuleMapping) {
        return executorToRuleMapping.entrySet().stream().map(entry -> PolicyEngineConfigurator.createExecutor((String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
    }

    private static RuleExecutor createExecutor(String executorClass, Collection<Rule> rules) {
        if (SINGLE_ARTIFACT_EXECUTOR.equals(executorClass)) {
            return new SingleArtifactExecutor(rules.stream().map(SingleArtifactRule.class::cast).collect(Collectors.toList()));
        }
        if (COMPARE_ARTIFACT_EXECUTOR.equals(executorClass)) {
            return new CompareArtifactExecutor(rules.stream().map(CompareArtifactRule.class::cast).collect(Collectors.toList()));
        }
        throw new IllegalStateException("Programming Error: Unknown executor class");
    }

    static class RuleToExecutor {
        private final Rule rule;
        private final String executorClass;

        private RuleToExecutor(Rule rule, String executorClass) {
            this.rule = rule;
            this.executorClass = executorClass;
        }

        Rule getRule() {
            return this.rule;
        }

        String getExecutorClass() {
            return this.executorClass;
        }
    }
}

