/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.workflow.processors;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSoftwareHeritageID;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceFile;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceUrl;
import org.eclipse.sw360.antenna.model.artifact.facts.ConfiguredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.DeclaredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ObservedLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.OverriddenLicenseInformation;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.util.ArtifactLicenseUtils;
import org.eclipse.sw360.antenna.policy.engine.model.LicenseData;
import org.eclipse.sw360.antenna.policy.engine.model.LicenseState;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;
import org.eclipse.sw360.antenna.policy.workflow.processors.AntennaLicenseData;

class AntennaArtifact
implements ThirdPartyArtifact {
    private final Artifact artifact;

    AntennaArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean isProprietary() {
        return this.artifact.isProprietary();
    }

    @Override
    public LicenseState getLicenseState() {
        if (this.artifact.askForGet(ConfiguredLicenseInformation.class).isPresent()) {
            return LicenseState.EXPLICITLY_SET;
        }
        if (this.artifact.askForGet(OverriddenLicenseInformation.class).isPresent()) {
            return LicenseState.EXPLICITLY_SET;
        }
        Optional declared = this.artifact.askForGet(DeclaredLicenseInformation.class);
        Optional observed = this.artifact.askForGet(ObservedLicenseInformation.class);
        if (declared.isPresent() && observed.isPresent()) {
            return LicenseState.DECLARED_AND_OBSERVED;
        }
        if (declared.isPresent()) {
            return LicenseState.DECLARED_ONLY;
        }
        if (observed.isPresent()) {
            return LicenseState.OBSERVED_ONLY;
        }
        return LicenseState.NO_LICENSE;
    }

    @Override
    public Collection<LicenseData> getLicenses() {
        return ArtifactLicenseUtils.getFinalLicenses((Artifact)this.artifact).getLicenses().stream().map(AntennaLicenseData::new).collect(Collectors.toList());
    }

    @Override
    public Optional<String> getLicenseExpression() {
        LicenseInformation licenseInformation = ArtifactLicenseUtils.getFinalLicenses((Artifact)this.artifact);
        if (licenseInformation.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(licenseInformation.evaluate());
    }

    @Override
    public Optional<URL> getSourceFileOrLink() {
        Optional sourcePath = this.artifact.askForGet(ArtifactSourceFile.class);
        if (sourcePath.isPresent()) {
            try {
                return Optional.of(((Path)sourcePath.get()).toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Optional sourceUrl = this.artifact.askForGet(ArtifactSourceUrl.class);
        if (sourceUrl.isPresent()) {
            try {
                return Optional.of(new URL((String)sourceUrl.get()));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getSWHSourceId() {
        return this.artifact.askForGet(ArtifactSoftwareHeritageID.class);
    }

    @Override
    public Collection<Coordinate> getCoordinates() {
        return this.artifact.getCoordinates();
    }
}

