/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.engine;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.RuleExecutor;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyEngine.class);
    private final Collection<RuleExecutor> executors;

    public PolicyEngine(Collection<RuleExecutor> executors) {
        this.executors = executors;
    }

    public Collection<PolicyViolation> evaluate(Collection<ThirdPartyArtifact> thirdPartyArtifacts) {
        LOGGER.debug("Artifacts are " + thirdPartyArtifacts.stream().map(ThirdPartyArtifact::getCoordinates).flatMap(Collection::stream).map(PackageURLFacade::canonicalize).collect(Collectors.joining(",", "[", "]")));
        Collection violations = this.executors.parallelStream().map(executor -> executor.executeRules(thirdPartyArtifacts)).flatMap(Collection::stream).collect(Collectors.toList());
        if (violations.size() > 0) {
            LOGGER.warn("Number of violations found: " + violations.size());
        } else {
            LOGGER.info("No violations found");
        }
        return violations;
    }

    public Collection<Ruleset> getRulesets() {
        return this.executors.stream().map(RuleExecutor::getRulesets).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

