/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.engine;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.coordinates.PackageURLFacade;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class PolicyViolation {
    private Rule rule;
    private Collection<ThirdPartyArtifact> failingArtifacts = new HashSet<ThirdPartyArtifact>();

    PolicyViolation(Rule rule, Collection<ThirdPartyArtifact> failingArtifacts) {
        this.rule = rule;
        this.failingArtifacts.addAll(failingArtifacts);
    }

    public String getId() {
        return this.rule.getId();
    }

    public String getName() {
        return this.rule.getName();
    }

    public String getDescription() {
        return this.rule.getDescription();
    }

    public RuleSeverity getSeverity() {
        return this.rule.getSeverity();
    }

    public String getViolationHash() {
        String hashBase = this.failingArtifacts.stream().map(this::getPurlAsString).flatMap(Collection::stream).collect(Collectors.joining(" : ", this.rule.getId() + " : ", ""));
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(hashBase.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Programming Error: Hash algorithm, resp. encoding unknown");
        }
    }

    private Collection<String> getPurlAsString(ThirdPartyArtifact artifact) {
        return artifact.getCoordinates().stream().map(PackageURLFacade::canonicalize).collect(Collectors.toList());
    }

    public Rule getRule() {
        return this.rule;
    }

    public Collection<ThirdPartyArtifact> getFailingArtifacts() {
        return Collections.unmodifiableCollection(this.failingArtifacts);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolicyViolation) {
            PolicyViolation other = (PolicyViolation)obj;
            if (this.rule.getId().equalsIgnoreCase(other.rule.getId()) && this.failingArtifacts.size() == other.failingArtifacts.size() && this.failingArtifacts.containsAll(other.failingArtifacts)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.failingArtifacts);
    }
}

