/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang3.Validate;
import org.eclipse.sw360.antenna.api.IConfigReader;
import org.eclipse.sw360.antenna.api.IXMLValidator;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.model.Configuration;
import org.eclipse.sw360.antenna.model.xml.generated.AntennaConfig;
import org.eclipse.sw360.antenna.xml.XMLResolverJaxB;
import org.eclipse.sw360.antenna.xml.XMLValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReader
implements IConfigReader {
    private static final String CONFIG_XML = "config.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReader.class);
    private URL configXsdURL;
    private XMLResolverJaxB xmlResolver;
    private IXMLValidator xmlValidator;

    public ConfigurationReader(URL xsdURL, Charset encoding) {
        this.configXsdURL = xsdURL;
        this.xmlResolver = new XMLResolverJaxB(encoding);
        this.xmlValidator = new XMLValidator();
    }

    public ConfigurationReader(Charset encoding) {
        this(AntennaConfig.getConfigXsd(), encoding);
    }

    public Configuration readConfigFromUri(URI configFileUri, Path antennaTargetDirectory) {
        Validate.notNull((Object)configFileUri, (String)"Configured config uri is null!", (Object[])new Object[0]);
        LOGGER.debug("Validate config file against xsd.");
        File configFile = this.resolveConfigUriAndGetFile(configFileUri, antennaTargetDirectory);
        return this.checkAndParseConfigXML(configFile, this.configXsdURL);
    }

    public Configuration readConfigFromFile(File configFile, Path antennaTargetDirectory) {
        Validate.isTrue((boolean)configFile.exists(), (String)("Configured config file '" + configFile + "' does not exist!"), (Object[])new Object[0]);
        Validate.isTrue((boolean)configFile.isFile(), (String)("Configured config file '" + configFile + "' must be a file!"), (Object[])new Object[0]);
        LOGGER.debug("Validate config file against xsd.");
        return this.checkAndParseConfigXML(configFile, this.configXsdURL);
    }

    private File resolveConfigUriAndGetFile(URI configFileUri, Path antennaTargetDirectory) {
        File configFromUri;
        if (configFileUri.getScheme().contains("file")) {
            configFromUri = new File(configFileUri);
        } else {
            Path destinationPath = antennaTargetDirectory.resolve(CONFIG_XML);
            configFromUri = destinationPath.toFile();
            try {
                boolean alreadyExisted = configFromUri.createNewFile();
                if (alreadyExisted) {
                    LOGGER.warn("Destination file already existed, continuing by overwriting the file.");
                }
                LOGGER.debug("Copy configuration file to target folder of antenna.");
                try (InputStream stream = configFileUri.toURL().openStream();){
                    Files.copy(stream, configFromUri.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to fetch file to target folder of antenna.", (Throwable)e);
            }
        }
        return configFromUri;
    }

    private Configuration checkAndParseConfigXML(File xmlFile, URL configXsdURL) {
        this.xmlValidator.validateXML(xmlFile, configXsdURL);
        AntennaConfig config = this.xmlResolver.resolveXML(xmlFile);
        return new Configuration(config);
    }
}

