/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.configuration;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.configuration.ConfigurationReader;
import org.eclipse.sw360.antenna.model.Configuration;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.eclipse.sw360.antenna.model.reporting.Report;
import org.eclipse.sw360.antenna.report.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleConfigsResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleConfigsResolver.class);
    private ConfigurationReader configurationReader;
    private Path antennaTargetDirectory;
    private Reporter tempReporter;

    public Configuration resolveConfigs(ToolConfiguration toolConfiguration) {
        return this.resolveConfigs(toolConfiguration, true);
    }

    protected Configuration resolveConfigs(ToolConfiguration toolConfiguration, boolean checkReport) {
        this.configurationReader = new ConfigurationReader(toolConfiguration.getEncoding());
        this.antennaTargetDirectory = toolConfiguration.getAntennaTargetDirectory();
        this.tempReporter = new Reporter(this.antennaTargetDirectory, toolConfiguration.getEncoding());
        List configFiles = toolConfiguration.getConfigFiles();
        List configFileUris = toolConfiguration.getConfigFileUris();
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        if (configFiles != null && !configFiles.isEmpty()) {
            configurations.addAll(this.resolveConfigs(configFiles));
        }
        if (configFileUris != null && !configFileUris.isEmpty()) {
            configurations.addAll(this.resolveUris(configFileUris));
        }
        Configuration resolvedConfigs = this.mergeConfigurations(configurations);
        LOGGER.debug("List of configurations merged.");
        if (checkReport) {
            this.checkReport();
        }
        return resolvedConfigs;
    }

    private ArrayList<Configuration> resolveConfigs(List<File> configs) {
        LOGGER.debug("Resolve list of configurations.");
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (File config : configs) {
            Configuration configuration = this.configurationReader.readConfigFromFile(config, this.antennaTargetDirectory);
            configurations.add(configuration);
        }
        return configurations;
    }

    private void checkReport() {
        Report processingReport = this.tempReporter.getProcessingReport();
        if (processingReport.getMessageList().size() > 0) {
            this.tempReporter.writeReport(System.out);
            this.tempReporter.writeReportToReportPath();
            String msg = "There are conflicting configurations. Please have a look at the processing Report and resolve them.";
            LOGGER.error(msg);
            throw new ConfigurationException(msg);
        }
    }

    private List<Configuration> resolveUris(List<URI> uris) {
        LOGGER.debug("Resolve list of configuration file uris.");
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (URI uri : uris) {
            Configuration configuration = this.configurationReader.readConfigFromUri(uri, this.antennaTargetDirectory);
            configurations.add(configuration);
        }
        return configurations;
    }

    private Configuration mergeConfigurations(List<Configuration> configurations) {
        if (configurations.size() == 0) {
            return new Configuration(null);
        }
        Configuration mergedConfig = new Configuration();
        this.mergeIgnoreForSourceResolving(configurations, mergedConfig);
        this.mergeOverride(configurations, mergedConfig);
        this.mergeValidForMissingSources(configurations, mergedConfig);
        this.mergeValidForIncompleteSources(configurations, mergedConfig);
        this.mergeRemoveArtifact(configurations, mergedConfig);
        this.mergeAddArtifact(configurations, mergedConfig);
        this.mergeFinalLicenses(configurations, mergedConfig);
        this.mergeFailOnIncompleteSources(configurations, mergedConfig);
        this.mergeFailOnMissingSources(configurations, mergedConfig);
        this.mergeSecurityIssues(configurations, mergedConfig);
        this.mergeSecurityIssueSuppresses(configurations, mergedConfig);
        return mergedConfig;
    }

    private void mergeSecurityIssues(List<Configuration> configurations, Configuration mergedConfig) {
        mergedConfig.setSecurityIssues(configurations.stream().map(Configuration::getSecurityIssues).map(Map::entrySet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private void mergeSecurityIssueSuppresses(List<Configuration> configurations, Configuration mergedConfig) {
        mergedConfig.setSuppressedSecurityIssues(configurations.stream().map(Configuration::getSuppressedSecurityIssues).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Configuration.suppressedSecurityIssuesConflictResolver)));
    }

    private void mergeAddArtifact(List<Configuration> configurations, Configuration mergedConfig) {
        ArrayList<Artifact> mergeAddArtifact = new ArrayList<Artifact>();
        for (Configuration configuration : configurations) {
            List addArtifact = configuration.getAddArtifact();
            for (Artifact artifact : addArtifact) {
                if (mergeAddArtifact.contains(artifact)) continue;
                mergeAddArtifact.add(artifact);
            }
        }
        mergedConfig.setAddArtifact(mergeAddArtifact);
    }

    private void mergeFinalLicenses(List<Configuration> configurations, Configuration mergedConfig) {
        HashMap mergedFinalLicenses = new HashMap();
        for (Configuration configuration : configurations) {
            Map setFinalLicense = configuration.getFinalLicenses();
            for (Map.Entry selectorEntry : setFinalLicense.entrySet()) {
                LicenseInformation actual;
                if (!mergedFinalLicenses.containsKey(selectorEntry.getKey())) {
                    mergedFinalLicenses.put(selectorEntry.getKey(), selectorEntry.getValue());
                    continue;
                }
                LicenseInformation merged = (LicenseInformation)mergedFinalLicenses.get(selectorEntry.getKey());
                if (merged.equals(actual = (LicenseInformation)setFinalLicense.get(selectorEntry.getKey()))) continue;
                this.tempReporter.add(MessageType.CONFLICTING_CONFIGURATIONS, "Conflicting configurations in the \"set final license\" section, the declared licenses are not the same. (artifact selector was=[" + ((ArtifactSelector)selectorEntry.getKey()).toString() + "])");
            }
        }
        mergedConfig.setFinalLicenses(mergedFinalLicenses);
    }

    private void mergeFailOnIncompleteSources(List<Configuration> configurations, Configuration mergedConfig) {
        boolean equal = configurations.get(0).isFailOnIncompleteSources();
        for (Configuration configuration : configurations) {
            if (equal == configuration.isFailOnIncompleteSources()) continue;
            this.tempReporter.add(MessageType.CONFLICTING_CONFIGURATIONS, "Conflicting configurations for the attribute \"failOnIncompleteSources\".");
        }
        mergedConfig.setFailOnIncompleteSources(equal);
    }

    private void mergeFailOnMissingSources(List<Configuration> configurations, Configuration mergedConfig) {
        boolean equal = configurations.get(0).isFailOnMissingSources();
        for (Configuration configuration : configurations) {
            if (equal == configuration.isFailOnMissingSources()) continue;
            this.tempReporter.add(MessageType.CONFLICTING_CONFIGURATIONS, "Conflicting configurations for the attribute \"failOnMissingSources\".");
            return;
        }
        mergedConfig.setFailOnMissingSources(equal);
    }

    private void mergeRemoveArtifact(List<Configuration> configurations, Configuration mergedConfig) {
        ArrayList mergedRemove = new ArrayList();
        for (Configuration configuration : configurations) {
            List removeArtifact = configuration.getRemoveArtifact();
            mergedRemove.addAll(removeArtifact);
        }
        mergedConfig.setRemoveArtifact(mergedRemove);
    }

    private void mergeValidForIncompleteSources(List<Configuration> configurations, Configuration mergedConfig) {
        mergedConfig.setValidForIncompleteSources(configurations.stream().map(Configuration::getValidForIncompleteSources).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    private void mergeValidForMissingSources(List<Configuration> configurations, Configuration mergedConfig) {
        mergedConfig.setValidForMissingSources(configurations.stream().map(Configuration::getValidForMissingSources).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    private void mergeOverride(List<Configuration> configurations, Configuration mergedConfig) {
        HashMap mergedOverride = new HashMap();
        for (Configuration configuration : configurations) {
            Map override = configuration.getOverride();
            for (Map.Entry selectorEntry : override.entrySet()) {
                Artifact compare = (Artifact)selectorEntry.getValue();
                if (mergedOverride.containsKey(selectorEntry.getKey())) {
                    Artifact generatedArtifact = (Artifact)mergedOverride.get(selectorEntry.getKey());
                    if (generatedArtifact.equals((Object)compare)) continue;
                    this.tempReporter.add(MessageType.CONFLICTING_CONFIGURATIONS, "Conflicting configurations in the override section at artifact: the override values are not equal. (artifact selector was=[" + ((ArtifactSelector)selectorEntry.getKey()).toString() + "])");
                    return;
                }
                mergedOverride.put(selectorEntry.getKey(), compare);
            }
        }
        mergedConfig.setOverride(mergedOverride);
    }

    private void mergeIgnoreForSourceResolving(List<Configuration> configurations, Configuration mergedConfig) {
        mergedConfig.setIgnoreForSourceResolving(configurations.stream().map(Configuration::getIgnoreForSourceResolving).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    public Reporter getReporter() {
        return this.tempReporter;
    }
}

