/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;

public class AntennaUtils {
    private static final String ARCHIVE_FILE_EXTENSIONS = "zip|war|jar|ear";

    private AntennaUtils() {
    }

    public static Iterator<Path> getJarPathIteratorFromPath(Path jarPath) {
        if (!jarPath.isAbsolute()) {
            throw new ExecutionException("This function should only be called with absolute paths");
        }
        return new TillJarGroupingIterator(jarPath);
    }

    public static Path getJarPath(URL url) throws URISyntaxException, MalformedURLException {
        if ("jar".equals(url.getProtocol())) {
            String file = url.getFile();
            if (file.contains("!")) {
                file = file.split("!", 2)[0];
            }
            url = new URL(file);
        }
        Path jarPath = Paths.get(url.toURI());
        return AntennaUtils.getJarPath(jarPath);
    }

    public static Path getJarPath(Path jarPath) {
        Iterator<Path> jarPathIterator = AntennaUtils.getJarPathIteratorFromPath(jarPath);
        if (!jarPathIterator.hasNext()) {
            throw new ExecutionException("Failed to parse jar path");
        }
        return jarPathIterator.next();
    }

    public static String replaceDotInJarExtension(String path) {
        return path.replaceAll("\\.(?=(zip|war|jar|ear)$)", "_");
    }

    public static Path computeInnerReplacementJarPath(Path jarPath) {
        Iterator<Path> jarPathIterator = AntennaUtils.getJarPathIteratorFromPath(jarPath);
        if (!jarPathIterator.hasNext()) {
            throw new ExecutionException("Tried to computeInnerReplacementPath from broken Path");
        }
        Path cleanedUp = jarPathIterator.next();
        while (jarPathIterator.hasNext()) {
            String basename = Optional.ofNullable(cleanedUp.getFileName()).orElseThrow(() -> new ExecutionException("Error in computeInnerReplacementJarPath")).toString();
            String parent = Optional.ofNullable(cleanedUp.getParent()).orElseThrow(() -> new ExecutionException("Error in computeInnerReplacementJarPath")).toString();
            String cleanedUpBasename = AntennaUtils.replaceDotInJarExtension(basename);
            cleanedUp = Paths.get(parent, cleanedUpBasename, jarPathIterator.next().toString());
        }
        return cleanedUp;
    }

    private static class TillJarGroupingIterator
    implements Iterator<Path> {
        private Iterator<Path> pathIterator;
        private Path currentRoot;
        private final Path root = Paths.get(File.separator, new String[0]);

        TillJarGroupingIterator(Path path) {
            this.pathIterator = path.toAbsolutePath().iterator();
            this.currentRoot = path.getRoot();
            if (this.currentRoot == null) {
                this.currentRoot = Paths.get(".", new String[0]);
            }
        }

        @Override
        public boolean hasNext() {
            return this.pathIterator.hasNext();
        }

        private boolean isNotAnArchive(Path pathEntry) {
            return !pathEntry.toString().matches(".*\\.(zip|war|jar|ear)$");
        }

        @Override
        public Path next() {
            Path next = this.currentRoot;
            while (this.pathIterator.hasNext() && this.isNotAnArchive(next)) {
                next = next.resolve(this.pathIterator.next());
            }
            this.currentRoot = this.root;
            return next;
        }
    }
}

