/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.http.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHelper.class);
    private final HttpClient httpClient;

    public HttpHelper(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public File downloadFile(String url, Path targetDirectory) throws IOException {
        String filename = url.substring(url.lastIndexOf("/") + 1);
        return this.downloadFile(url, targetDirectory, filename);
    }

    public File downloadFile(String url, Path targetDirectory, String filename) throws IOException {
        LOGGER.debug("Downloading from URL {} to file {} in {}.", new Object[]{url, filename, targetDirectory});
        Path targetFile = targetDirectory.resolve(filename);
        return (File)HttpUtils.waitFor((CompletableFuture)this.httpClient.execute(HttpUtils.get((String)url), HttpUtils.checkResponse(response -> {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            Files.copy(response.bodyStream(), targetFile, StandardCopyOption.REPLACE_EXISTING);
            return targetFile.toFile();
        })));
    }
}

