/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.Validate;
import org.eclipse.sw360.antenna.api.IXMLValidator;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XMLValidator
extends IXMLValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLValidator.class);

    public void validateXML(File xmlFile, URL xsdUrl) {
        Validate.notNull((Object)xmlFile, (String)"No URL to xml file provided!", (Object[])new Object[0]);
        if (xsdUrl != null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                Schema schema = factory.newSchema(xsdUrl);
                Validator validator = schema.newValidator();
                StreamSource source = new StreamSource(xmlFile);
                validator.validate(source);
            }
            catch (SAXException e) {
                LOGGER.error("Invalid XML", (Throwable)e);
                throw new ConfigurationException("The config File " + xmlFile + " could not be validated against" + xsdUrl, (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("File access failing", (Throwable)e);
                throw new ConfigurationException("The config File could not be validated", (Throwable)e);
            }
        }
    }
}

