/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.sw360.antenna.api.Attachable;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIdentifier;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.eclipse.sw360.antenna.model.reporting.ProcessingMessage;
import org.eclipse.sw360.antenna.model.reporting.ProcessingMessageWithPayload;
import org.eclipse.sw360.antenna.model.reporting.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter
implements IProcessingReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reporter.class);
    private static final String REPORT_FILENAME = "Antenna_3rdPartyAnalysisReport.txt";
    private static final String CLASSIFIER = "antenna-processing-report";
    private static final String TYPE = "txt";
    private Report report;
    private Path targetDirectory;
    private final Charset encoding;
    private final Path reportPath;

    public Reporter(Path targetDirectory) {
        this(targetDirectory, StandardCharsets.UTF_8);
    }

    public Reporter(Path targetDirectory, Charset encoding) {
        this.targetDirectory = targetDirectory;
        this.report = new Report();
        this.encoding = encoding;
        this.reportPath = targetDirectory.resolve(REPORT_FILENAME);
        File fTargetDirectory = targetDirectory.toFile();
        if (!fTargetDirectory.exists() && !fTargetDirectory.mkdirs()) {
            throw new ExecutionException("Target directory: " + fTargetDirectory + " cannot be created.");
        }
    }

    public Report getProcessingReport() {
        return this.report;
    }

    private void writeFormattedMessage(PrintStream stream, ProcessingMessage message) {
        String spacer = "    ";
        if (message.getIdentifier() != null) {
            stream.format("%s:%n%s%s: %s%n", message.getMessageType(), "    ", message.getIdentifier(), message.getMessage().replaceAll("\n", "\n            "));
        } else {
            stream.format("%s:%n%s%s%n", message.getMessageType(), "    ", message.getMessage().replaceAll("\n", "\n    "));
        }
        if (message instanceof ProcessingMessageWithPayload) {
            ((ProcessingMessageWithPayload)message).getPayload().forEach(payloadMsg -> stream.format("%s%s- %s", "    ", "    ", payloadMsg.replaceAll("\n", "\n          ")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReport(OutputStream out) {
        try (PrintStream stream = new PrintStream(out, false, this.encoding.toString());){
            List msgList;
            List list = msgList = this.report.getMessageList();
            synchronized (list) {
                msgList.forEach(msg -> this.writeFormattedMessage(stream, (ProcessingMessage)msg));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ExecutionException("Could not start printstream.", (Throwable)e);
        }
    }

    public void add(MessageType type, String message) {
        ProcessingMessage msg = new ProcessingMessage(type, message);
        this.report.add(msg);
    }

    public void add(String identifier, MessageType type, String message) {
        ProcessingMessage msg = new ProcessingMessage(type, identifier, message);
        this.report.add(msg);
    }

    public void add(Artifact artifact, MessageType type, String message) {
        ProcessingMessage msg = new ProcessingMessage(type, artifact.toString(), message);
        this.report.add(msg);
    }

    public void add(ArtifactIdentifier id, MessageType type, String message) {
        ProcessingMessage msg = new ProcessingMessage(type, id.toString(), message);
        this.report.add(msg);
    }

    public void add(ProcessingMessage msg) {
        this.report.add(msg);
    }

    private void createReportPath() throws IOException {
        Files.createDirectories(this.targetDirectory, new FileAttribute[0]);
    }

    public IAttachable writeReportToReportPath() {
        try {
            this.createReportPath();
            LOGGER.debug("Writing report to {}", (Object)this.reportPath.toString());
            try (FileOutputStream out = new FileOutputStream(this.reportPath.toFile());){
                this.writeReport(out);
            }
            return new Attachable(TYPE, CLASSIFIER, this.reportPath.toFile());
        }
        catch (IOException e) {
            throw new ExecutionException("The processing report could not be created.", (Throwable)e);
        }
    }
}

