/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.testing.util;

import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.function.BiConsumer;

public class AntennaTestingUtils {
    private static final String testUrl = "https://www.eclipse.org";

    private AntennaTestingUtils() {
    }

    public static void checkInternetConnectionAndAssume(BiConsumer<String, Boolean> assumer) {
        AntennaTestingUtils.checkInternetConnection().ifPresent(e -> assumer.accept("Can not reach the internet (due to " + e.getClass().getSimpleName() + ")", false));
    }

    public static Optional<Exception> checkInternetConnection() {
        return AntennaTestingUtils.checkInternetConnection(testUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Exception> checkInternetConnection(String url) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.connect();
            Optional<Exception> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            Optional<Exception> optional = Optional.of(e);
            return optional;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void setVariableValueInObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = AntennaTestingUtils.getFieldIncludingSuperclasses(variable, object.getClass());
        field.setAccessible(true);
        field.set(object, value);
    }

    private static Field getFieldIncludingSuperclasses(String fieldName, Class<?> clazz) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException var5) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return AntennaTestingUtils.getFieldIncludingSuperclasses(fieldName, superclass);
            }
            throw new IllegalArgumentException("Could not find field " + fieldName);
        }
    }
}

