/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.AbstractAnalyzer;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.workflow.WorkflowItemFactory;

public class AnalyzerFactory
extends WorkflowItemFactory {
    public static List<AbstractAnalyzer> getAnalyzers(Workflow workflow, AntennaContext context) {
        if (workflow == null) {
            throw new ConfigurationException("No <workflow> section was found in your configuration.");
        }
        if (workflow.getAnalyzers() == null) {
            return Collections.emptyList();
        }
        List analyzersRequested = workflow.getAnalyzers().getStep();
        return analyzersRequested.stream().filter(ar -> Optional.ofNullable(ar.isDeactivated()).orElse(false) == false).map(ar -> {
            LOGGER.debug("Loading the {} analyzer", (Object)ar.getName());
            return (AbstractAnalyzer)WorkflowItemFactory.buildWorkflowItem(ar, ar.getConfiguration(), context, ar.getWorkflowStepOrder());
        }).sorted(Comparator.comparingInt(ConfigurableWorkflowItem::getWorkflowStepOrder)).collect(Collectors.toList());
    }
}

