/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.api.workflow.AbstractAnalyzer;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.api.workflow.AbstractOutputHandler;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.api.workflow.ProcessingState;
import org.eclipse.sw360.antenna.api.workflow.WorkflowStepResult;
import org.eclipse.sw360.antenna.workflow.AntennaWorkflowConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntennaWorkflow {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntennaWorkflow.class);
    private final Collection<AbstractAnalyzer> analyzers;
    private final Collection<AbstractProcessor> processors;
    private final Collection<AbstractGenerator> generators;
    private final List<AbstractOutputHandler> postSinksHooks;

    public AntennaWorkflow(AntennaWorkflowConfiguration antennaWFConfig) {
        LOGGER.debug("Initializing workflow ...");
        this.analyzers = antennaWFConfig.getAnalyzers();
        this.processors = antennaWFConfig.getProcessors();
        this.generators = antennaWFConfig.getGenerators();
        this.postSinksHooks = antennaWFConfig.getOutputHandlers();
        LOGGER.debug("Initializing workflow done\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IAttachable> execute() {
        LOGGER.info("Workflow execution started ...");
        try {
            LOGGER.debug("Start collecting dependencies from");
            Collection<WorkflowStepResult> sourcesResults = this.getArtifactsFromAnalyzers();
            ProcessingState processingState = new ProcessingState(sourcesResults);
            if (processingState.getArtifacts().isEmpty()) {
                LOGGER.warn("No analyzer yielded artifacts, skip all other workflow steps");
                Map map = processingState.getAttachables();
                return map;
            }
            LOGGER.debug("Process artifacts");
            this.applyProcessors(processingState);
            LOGGER.debug("Generate output");
            Map<String, IAttachable> generatedOutput = this.generateOutputViaGenerators(processingState);
            generatedOutput.putAll(processingState.getAttachables());
            if (!processingState.getFailCausingResults().isEmpty()) {
                this.logFailCausingResults(processingState.getFailCausingResults());
                throw new ExecutionException("Build failed due to fail causing results.");
            }
            if (this.postSinksHooks.size() > 0) {
                LOGGER.debug("Post process output");
                this.applyOutputPostHandler(generatedOutput);
            }
            Map<String, IAttachable> map = generatedOutput;
            return map;
        }
        finally {
            LOGGER.debug("Clean up workflow ...");
            this.cleanup();
            LOGGER.debug("Clean up workflow done");
            LOGGER.debug("Workflow execution done");
        }
    }

    private void logFailCausingResults(Map<String, Set<IEvaluationResult>> failCausingResults) {
        this.makeStringForFailCausingResults(failCausingResults).forEach(arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    private Collection<String> makeStringForFailCausingResults(Map<String, Set<IEvaluationResult>> failCausingResults) {
        ArrayList<String> resultLines = new ArrayList<String>();
        resultLines.add("Build fails due to fail causing results");
        failCausingResults.forEach((workflowItemName, evaluationResults) -> this.createResultLines((Collection<String>)resultLines, (String)workflowItemName, (Set<IEvaluationResult>)evaluationResults));
        return resultLines;
    }

    private void createResultLines(Collection<String> resultLines, String workflowItemName, Set<IEvaluationResult> evaluationResults) {
        evaluationResults.stream().forEach(evalRes -> resultLines.add(String.format("%s: %s", workflowItemName, evalRes.resultAsMessage())));
    }

    private Collection<WorkflowStepResult> getArtifactsFromAnalyzers() {
        HashSet<WorkflowStepResult> results = new HashSet<WorkflowStepResult>();
        for (AbstractAnalyzer source : this.analyzers) {
            LOGGER.info("Run {}", (Object)source.getWorkflowItemName());
            results.add(source.yield());
        }
        return results;
    }

    private void applyProcessors(ProcessingState processingState) {
        for (AbstractProcessor processor : this.processors) {
            LOGGER.info("Run {}", (Object)processor.getWorkflowItemName());
            processingState.applyWorkflowStepResult(processor.process(processingState));
        }
    }

    private void warnIfKeysCollide(AbstractGenerator sink, Map<String, IAttachable> generatedOutput, Map<String, IAttachable> oneGeneratedOutput) {
        Set collidingKeys = generatedOutput.keySet().stream().filter(oneGeneratedOutput.keySet()::contains).collect(Collectors.toSet());
        if (collidingKeys.size() > 0) {
            LOGGER.warn("The generator " + sink.getWorkflowItemName() + " overwrites the generated output with the keys:\n\t" + String.join((CharSequence)", ", collidingKeys));
        }
    }

    private Map<String, IAttachable> generateOutputViaGenerators(ProcessingState processingState) {
        HashMap<String, IAttachable> generatedOutput = new HashMap<String, IAttachable>();
        for (AbstractGenerator sink : this.generators) {
            LOGGER.info("Run {}", (Object)sink.getWorkflowItemName());
            Map oneGeneratedOutput = sink.produce(processingState);
            this.warnIfKeysCollide(sink, generatedOutput, oneGeneratedOutput);
            generatedOutput.putAll(oneGeneratedOutput);
        }
        return generatedOutput;
    }

    private void applyOutputPostHandler(Map<String, IAttachable> generatedOutput) {
        for (AbstractOutputHandler postSinksHook : this.postSinksHooks) {
            postSinksHook.handle(generatedOutput);
        }
    }

    private void cleanup() {
        Stream.of(this.analyzers, this.processors, this.generators, this.postSinksHooks).flatMap(Collection::stream).forEach(ConfigurableWorkflowItem::cleanup);
    }
}

