/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.workflow.WorkflowItemFactory;

public class ProcessorFactory
extends WorkflowItemFactory {
    public static List<AbstractProcessor> getProcessors(Workflow workflow, AntennaContext context) {
        if (workflow == null) {
            throw new ConfigurationException("No <workflow> section was found in your configuration.");
        }
        if (workflow.getProcessors() == null) {
            return Collections.emptyList();
        }
        List processorsRequested = workflow.getProcessors().getStep();
        if (processorsRequested.size() == 0) {
            LOGGER.warn("No processors were found in your <workflow> section.");
        }
        return ((Stream)processorsRequested.stream().parallel()).filter(pr -> Optional.ofNullable(pr.isDeactivated()).orElse(false) == false).map(pr -> {
            LOGGER.debug("Loading the {} processor", (Object)pr.getName());
            return (AbstractProcessor)WorkflowItemFactory.buildWorkflowItem(pr, pr.getConfiguration(), context, pr.getWorkflowStepOrder());
        }).sorted(Comparator.comparingInt(ConfigurableWorkflowItem::getWorkflowStepOrder)).collect(Collectors.toList());
    }
}

