/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.workflow.AntennaWorkflow;
import org.eclipse.sw360.antenna.workflow.AntennaWorkflowConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntennaCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntennaCore.class);
    private final AntennaWorkflow tw;
    private final AntennaContext context;

    public Map<String, IAttachable> compose() {
        if (this.context.getToolConfiguration().isSkipAntennaExecution()) {
            LOGGER.warn("Antenna execution is skipped.");
            return new HashMap<String, IAttachable>();
        }
        return this.tw.execute();
    }

    public AntennaCore(AntennaContext context) {
        this.context = context;
        LOGGER.debug("Initializing core ...");
        AntennaWorkflowConfiguration twc = new AntennaWorkflowConfiguration(context);
        this.tw = new AntennaWorkflow(twc);
        LOGGER.debug("Initializing core done");
    }

    public IAttachable writeAnalysisReport() {
        LOGGER.debug("Create Analysis Report...");
        IAttachable report = this.context.getProcessingReporter().writeReportToReportPath();
        LOGGER.debug("Create Analysis Report...done");
        return report;
    }

    public AntennaContext getAntennaContext() {
        return this.context;
    }
}

