/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.testing.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;

public class JarCreator {
    private Path workspace = Files.createTempDirectory("testRepo", new FileAttribute[0]);
    public static final String jarWithManifestName = "testWithManifest.jar";
    public static final String jarWithoutManifestName = "testWithoutManifest.jar";
    public static final String jarWithSourcesName = "JarWithArtifactSource.jar";
    public static final String jarInJarName = "JarInJarWM.jar";
    public static final String jarInFoldersName = "META-INF/libs/testWithManifest.jar";
    public static final String jarInJarInJarName = "JarInJarInJarWM.jar";
    public static final String testManifestSymbolicName = "org.test.someorga";
    public static final String testManifestVersion = "2.2.3-SNAPSHOT";
    public Path jarWithManifestPath;
    public Path jarWithoutManifestPath;
    public Path jarWithSourcesPath;
    public Path jarjarjarPath;
    public static final Manifest manifest = new Manifest();

    public Path getWorkspace() {
        return this.workspace;
    }

    public void cleanUp() {
        try {
            FileUtils.deleteDirectory((File)this.workspace.toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Could not clean up. Deletion of test project failed.");
        }
    }

    public Path createJarWithManifest() throws IOException {
        return this.createJarWithManifest(jarWithManifestName);
    }

    public Path createJarWithManifest(String name) throws IOException {
        this.jarWithManifestPath = this.workspace.resolve(name);
        File file = this.jarWithManifestPath.toFile();
        if (file.exists()) {
            return this.jarWithManifestPath;
        }
        if (this.jarWithManifestPath.getParent() != null) {
            Path parent = Optional.ofNullable(this.jarWithManifestPath.getParent()).orElseThrow(() -> new ExecutionException("The JarWithManifest=[" + this.jarWithManifestPath + "] should have a parent"));
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (FileOutputStream fileOutput = new FileOutputStream(file);
             JarOutputStream jarOutput = new JarOutputStream((OutputStream)fileOutput, manifest);){
            jarOutput.flush();
        }
        return this.jarWithManifestPath;
    }

    public Path createJarWithoutManifest() throws IOException {
        this.jarWithoutManifestPath = this.workspace.resolve(jarWithoutManifestName);
        File file = this.jarWithoutManifestPath.toFile();
        if (file.exists()) {
            return this.jarWithoutManifestPath;
        }
        try (FileOutputStream fileOutput = new FileOutputStream(file);
             JarOutputStream jarOutput = new JarOutputStream(fileOutput);){
            ZipEntry ze = new ZipEntry("empty");
            jarOutput.putNextEntry(ze);
            jarOutput.closeEntry();
            jarOutput.flush();
        }
        return this.jarWithoutManifestPath;
    }

    public File createJarWithSource() throws IOException {
        this.jarWithSourcesPath = this.workspace.resolve(jarWithSourcesName);
        File file = this.jarWithSourcesPath.toFile();
        if (file.exists()) {
            return file;
        }
        try (FileOutputStream fileOutput = new FileOutputStream(file);
             JarOutputStream jarOutput = new JarOutputStream(fileOutput);){
            ZipEntry zedirectory = new ZipEntry("Jarsrc");
            jarOutput.putNextEntry(zedirectory);
            ZipEntry ze = new ZipEntry("Jarsrc/source.java");
            jarOutput.putNextEntry(ze);
            ze = new ZipEntry("Jarsrc/source2.java");
            jarOutput.putNextEntry(ze);
            ze = new ZipEntry("Jarsrc/source3.java");
            jarOutput.putNextEntry(ze);
        }
        return file;
    }

    private void createNestedJar(File innerJar, File outerJar) throws IOException {
        this.createNestedJar("", innerJar, outerJar);
    }

    private void createNestedJar(String subDirs, File innerJar, File outerJar) throws IOException {
        try (FileOutputStream outJarInJar = new FileOutputStream(outerJar);
             JarOutputStream jaroutJarInJar = new JarOutputStream(outJarInJar);){
            ZipEntry zipE = new ZipEntry(Paths.get(subDirs, innerJar.getName()).toString());
            jaroutJarInJar.putNextEntry(zipE);
            Files.copy(innerJar.toPath(), jaroutJarInJar);
            jaroutJarInJar.closeEntry();
        }
    }

    public Path createJarInJar() throws IOException {
        Path jarjarPath = this.workspace.resolve(jarInJarName);
        File jarInJar = jarjarPath.toFile();
        if (jarInJar.exists()) {
            return jarjarPath;
        }
        File jarWithManifest = this.createJarWithManifest(jarWithManifestName).toFile();
        this.createNestedJar(jarWithManifest, jarInJar);
        return jarjarPath;
    }

    public Path createJarInJarInJar() throws IOException {
        this.jarjarjarPath = this.workspace.resolve(jarInJarInJarName);
        File jarInJarInJar = this.jarjarjarPath.toFile();
        if (jarInJarInJar.exists()) {
            return this.jarjarjarPath;
        }
        File jarInJar = this.createJarInJar().toFile();
        this.createNestedJar(jarInJar, jarInJarInJar);
        return this.jarjarjarPath;
    }

    public Path createJarInJarInNestedFolders() throws IOException {
        Path jarjarPath = this.workspace.resolve(jarInJarName);
        File jarInJar = jarjarPath.toFile();
        if (jarInJar.exists()) {
            return jarjarPath;
        }
        File jarWithManifest = this.createJarWithManifest(jarInFoldersName).toFile();
        String parent = Optional.ofNullable(Paths.get(jarInFoldersName, new String[0]).getParent()).orElseThrow(() -> new ExecutionException("The Path [META-INF/libs/testWithManifest.jar] should have a parent")).toString();
        this.createNestedJar(parent, jarWithManifest, jarInJar);
        return jarjarPath;
    }

    static {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Bundle-SymbolicName", "org.test.someorga;singleton:=true");
        manifest.getMainAttributes().putValue("Bundle-Version", testManifestVersion);
    }
}

