/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlSettingsReader {
    private Document doc;
    private XPath xpath;

    public XmlSettingsReader(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder dBuilder = this.initDocumentBuilder();
        dBuilder.setErrorHandler(null);
        this.doc = dBuilder.parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
        this.doc.getDocumentElement().normalize();
        this.xpath = this.initXPath();
    }

    private DocumentBuilder initDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        return dbFactory.newDocumentBuilder();
    }

    private XPath initXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public int getIntProperty(String xPathExp, String tagName, int defaultVal) {
        return this.getElementByXPath(xPathExp, tagName, node -> {
            try {
                return Integer.parseInt(node.getTextContent());
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }, defaultVal);
    }

    public String getStringPropertyByXPath(String xPathExp, String tagName) {
        return this.getStringPropertyByXPath(xPathExp, tagName, null);
    }

    public String getStringPropertyByXPath(String xPathExp, String tagName, String defaultVal) {
        return this.getElementByXPath(xPathExp, tagName, n -> n.getTextContent().trim(), defaultVal);
    }

    public boolean getBooleanProperty(String xPathExp, String tagName, boolean defaultVal) {
        return this.getElementByXPath(xPathExp, tagName, node -> {
            try {
                return Boolean.parseBoolean(node.getTextContent());
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }, defaultVal);
    }

    public String getStringProperty(String tagName) {
        return this.getStringProperty(tagName, null);
    }

    public File getFileProperty(String tagName) {
        return Optional.ofNullable(this.getStringProperty(tagName, null)).map(File::new).orElse(null);
    }

    public String getStringProperty(String tagName, String defaultValue) {
        Node property = this.getElement(this.doc, tagName);
        if (property == null) {
            return defaultValue;
        }
        if (property.getNodeType() == 1) {
            return property.getTextContent().trim();
        }
        return null;
    }

    public List<String> getStringListProperty(String tagName) {
        ArrayList<String> propertyStrings = new ArrayList<String>();
        NodeList propertyList = this.doc.getElementsByTagName(tagName);
        if (propertyList.getLength() == 0) {
            return propertyStrings;
        }
        if (propertyList.item(0).getNodeType() == 1) {
            Element parentElement = (Element)propertyList.item(0);
            NodeList childProperties = parentElement.getElementsByTagName("param");
            for (int i = 0; i < childProperties.getLength(); ++i) {
                propertyStrings.add(childProperties.item(i).getTextContent().trim());
            }
        }
        return propertyStrings;
    }

    public Map<String, Boolean> getStringKeyedBooleanMapProperty(String tagName) {
        return this.getStringKeyedMapProperty(tagName, Boolean::parseBoolean);
    }

    public <T> Map<String, T> getStringKeyedMapProperty(String tagName, Function<String, T> mapFunction) {
        NodeList propertyList = this.doc.getElementsByTagName(tagName);
        if (propertyList.getLength() == 0 || propertyList.item(0).getNodeType() != 1) {
            return Collections.emptyMap();
        }
        Element parentElement = (Element)propertyList.item(0);
        NodeList childProperties = parentElement.getChildNodes();
        HashMap<String, T> resultMap = new HashMap<String, T>();
        for (int i = 0; i < childProperties.getLength(); ++i) {
            resultMap.put(childProperties.item(i).getNodeName(), mapFunction.apply(childProperties.item(i).getTextContent().trim()));
        }
        return resultMap;
    }

    public <T> T getComplexType(String tagName, Class<T> targetClass) {
        Node property = this.getElement(this.doc, tagName);
        if (property == null) {
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement jb = unmarshaller.unmarshal(property, targetClass);
            return (T)jb.getValue();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Problem extracting " + targetClass + " from settings: " + e.getMessage());
        }
    }

    private Node getElement(Document doc, String tagName) {
        NodeList nodes = doc.getElementsByTagName(tagName);
        if (nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    private <T> T getElementByXPath(String xPathExp, String tagName, Function<Node, T> callback, T defaultValue) {
        Node node;
        Optional<Node> property = this.getElementByXPath(xPathExp, tagName);
        if (property.isPresent() && (node = property.get()).getNodeType() == 1) {
            return callback.apply(node);
        }
        return defaultValue;
    }

    private Optional<Node> getElementByXPath(String xPathExp, String tagName) {
        String xPathExpWithTag = xPathExp + "/" + tagName;
        try {
            XPathExpression exp = this.xpath.compile(xPathExp + "/" + tagName);
            return Optional.ofNullable((Node)exp.evaluate(this.doc, XPathConstants.NODE));
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Could not evaluate XPath expression: " + xPathExpWithTag, e);
        }
    }
}

