/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipExtractor {
    public static void extractAll(File zipFile, File destination) throws IOException {
        try (FileInputStream fs = new FileInputStream(zipFile.toString());
             ZipInputStream zipInputStream = new ZipInputStream(fs);){
            byte[] buffer = new byte[1024];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                ZipExtractor.extractEntry(destination.toPath().normalize().toFile(), zipInputStream, buffer, zipEntry);
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private static void extractEntry(File destination, ZipInputStream zipInputStream, byte[] buffer, ZipEntry zipEntry) throws IOException {
        File newFile = ZipExtractor.newFile(destination, zipEntry);
        if (newFile.isDirectory()) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(newFile);){
            int len;
            while ((len = zipInputStream.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
    }

    private static File newFile(File destinationDirectory, ZipEntry zipEntry) throws IOException {
        File newFile = new File(destinationDirectory, zipEntry.getName());
        ZipExtractor.createFile(zipEntry, newFile);
        if (!newFile.toPath().normalize().startsWith(destinationDirectory.toPath())) {
            throw new IOException("Entry " + newFile.getPath() + " lies outside of temporary target directory: " + destinationDirectory.getPath() + ". It would not be properly deleted.");
        }
        return newFile;
    }

    private static void createFile(ZipEntry zipEntry, File newFile) throws IOException {
        if (zipEntry.isDirectory()) {
            if (!newFile.isDirectory() && !newFile.mkdirs()) {
                throw new IOException("Failed to create directory '" + newFile + "'.");
            }
        } else {
            File parentDir = newFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                throw new IOException("Failed to create directory '" + parentDir + "'.");
            }
            if (!newFile.isFile() && !newFile.createNewFile()) {
                throw new IOException("Failed to create file '" + newFile + "'.");
            }
        }
    }
}

