/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow;

import java.util.Collection;
import java.util.List;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.AbstractAnalyzer;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.api.workflow.AbstractOutputHandler;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.api.workflow.ConfigurableWorkflowItem;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.workflow.AnalyzerFactory;
import org.eclipse.sw360.antenna.workflow.GeneratorFactory;
import org.eclipse.sw360.antenna.workflow.OutputHandlerFactory;
import org.eclipse.sw360.antenna.workflow.ProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntennaWorkflowConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntennaWorkflowConfiguration.class);
    private final List<AbstractAnalyzer> analyzers;
    private final List<AbstractProcessor> processors;
    private final List<AbstractGenerator> generators;
    private final List<AbstractOutputHandler> outputHandlers;

    public AntennaWorkflowConfiguration(AntennaContext context) {
        LOGGER.debug("Initializing workflow configuration ...");
        Workflow workflow = context.getToolConfiguration().getWorkflow();
        if (workflow == null) {
            throw new ConfigurationException("No workflow was found in configuration.");
        }
        this.analyzers = AnalyzerFactory.getAnalyzers(workflow, context);
        if (this.analyzers.isEmpty()) {
            LOGGER.warn("No analyzers found. You might want to check your configuration.");
        }
        this.processors = ProcessorFactory.getProcessors(workflow, context);
        if (this.processors.isEmpty()) {
            LOGGER.warn("No processors found. You might want to check your configuration.");
        }
        this.debugLogAndWarnOnDuplicateOrders("processors", this.processors);
        this.generators = GeneratorFactory.getGenerators(workflow, context);
        if (this.generators.isEmpty()) {
            LOGGER.warn("No generators found. You might want to check your configuration.");
        }
        this.outputHandlers = OutputHandlerFactory.getOutputHandlers(workflow, context);
        LOGGER.debug("Initializing workflow configuration done");
    }

    public Collection<AbstractAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    public Collection<AbstractProcessor> getProcessors() {
        return this.processors;
    }

    public Collection<AbstractGenerator> getGenerators() {
        return this.generators;
    }

    public List<AbstractOutputHandler> getOutputHandlers() {
        return this.outputHandlers;
    }

    private void debugLogAndWarnOnDuplicateOrders(String nameOfSteps, List<? extends ConfigurableWorkflowItem> items) {
        LOGGER.debug("The calculated order of " + nameOfSteps + " is:");
        for (int i = 0; i < items.size(); ++i) {
            LOGGER.debug("    - " + items.get(i).getWorkflowStepOrder() + ": " + items.get(i).getWorkflowItemName());
            if (i <= 0 || items.get(i - 1).getWorkflowStepOrder() != items.get(i).getWorkflowStepOrder()) continue;
            LOGGER.warn("Workflow steps " + items.get(i - 1).getWorkflowItemName() + " and " + items.get(i).getWorkflowItemName() + " have the same step order. The former will be executed before the latter.");
        }
    }
}

